/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.cluster.strategy.ClusteringExecutionStrategy;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;

public class JavaExecuteClusteringCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends BaseJavaCommitActionExecutor<T> {
    private final HoodieClusteringPlan clusteringPlan;

    public JavaExecuteClusteringCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime) {
        super(context, config, table, instantTime, WriteOperationType.CLUSTER);
        this.clusteringPlan = (HoodieClusteringPlan)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)table.getMetaClient(), (HoodieInstant)HoodieTimeline.getReplaceCommitRequestedInstant((String)instantTime)).map(Pair::getRight).orElseThrow(() -> new HoodieClusteringException("Unable to read clustering plan for instant: " + instantTime));
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        HoodieInstant instant = HoodieTimeline.getReplaceCommitRequestedInstant((String)this.instantTime);
        this.table.getActiveTimeline().transitionReplaceRequestedToInflight(instant, Option.empty());
        this.table.getMetaClient().reloadActiveTimeline();
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(this.config.getSchema()));
        HoodieWriteMetadata writeMetadata = ((ClusteringExecutionStrategy)ReflectionUtils.loadClass((String)this.config.getClusteringExecutionStrategyClass(), (Class[])new Class[]{HoodieTable.class, HoodieEngineContext.class, HoodieWriteConfig.class}, (Object[])new Object[]{this.table, this.context, this.config})).performClustering(this.clusteringPlan, schema, this.instantTime);
        List writeStatusList = (List)writeMetadata.getWriteStatuses();
        List<WriteStatus> statuses = this.updateIndex(writeStatusList, (HoodieWriteMetadata<List<WriteStatus>>)writeMetadata);
        writeMetadata.setWriteStats(statuses.stream().map(WriteStatus::getStat).collect(Collectors.toList()));
        writeMetadata.setPartitionToReplaceFileIds(this.getPartitionToReplacedFileIds((HoodieWriteMetadata<List<WriteStatus>>)writeMetadata));
        this.validateWriteResult((HoodieWriteMetadata<List<WriteStatus>>)writeMetadata);
        this.commitOnAutoCommit(writeMetadata);
        if (!writeMetadata.getCommitMetadata().isPresent()) {
            HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata((List)((List)writeMetadata.getWriteStats().get()), (Map)writeMetadata.getPartitionToReplaceFileIds(), (Option)this.extraMetadata, (WriteOperationType)this.operationType, (String)this.getSchemaToStoreInCommit(), (String)this.getCommitActionType());
            writeMetadata.setCommitMetadata(Option.of((Object)commitMetadata));
        }
        return writeMetadata;
    }

    private void validateWriteResult(HoodieWriteMetadata<List<WriteStatus>> writeMetadata) {
        if (((List)writeMetadata.getWriteStatuses()).isEmpty()) {
            throw new HoodieClusteringException("Clustering plan produced 0 WriteStatus for " + this.instantTime + " #groups: " + this.clusteringPlan.getInputGroups().size() + " expected at least " + this.clusteringPlan.getInputGroups().stream().mapToInt(HoodieClusteringGroup::getNumOutputFileGroups).sum() + " write statuses");
        }
    }

    @Override
    protected String getCommitActionType() {
        return "replacecommit";
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<List<WriteStatus>> writeMetadata) {
        Set newFilesWritten = ((List)writeMetadata.getWriteStats().get()).stream().map(s -> new HoodieFileGroupId(s.getPartitionPath(), s.getFileId())).collect(Collectors.toSet());
        return ClusteringUtils.getFileGroupsFromClusteringPlan((HoodieClusteringPlan)this.clusteringPlan).filter(fg -> !newFilesWritten.contains(fg)).collect(Collectors.groupingBy(fg -> fg.getPartitionPath(), Collectors.mapping(fg -> fg.getFileId(), Collectors.toList())));
    }
}

