/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.JavaLazyInsertIterable;
import org.apache.hudi.execution.bulkinsert.JavaBulkInsertInternalPartitionerFactory;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.FileIdPrefixProvider;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.AbstractBulkInsertHelper;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaWriteHelper;

public class JavaBulkInsertHelper<T extends HoodieRecordPayload, R>
extends AbstractBulkInsertHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private JavaBulkInsertHelper() {
    }

    public static JavaBulkInsertHelper newInstance() {
        return BulkInsertHelperHolder.JAVA_BULK_INSERT_HELPER;
    }

    public HoodieWriteMetadata<List<WriteStatus>> bulkInsert(List<HoodieRecord<T>> inputRecords, String instantTime, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieWriteConfig config, BaseCommitActionExecutor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> executor, boolean performDedupe, Option<BulkInsertPartitioner<T>> userDefinedBulkInsertPartitioner) {
        HoodieWriteMetadata result = new HoodieWriteMetadata();
        if (!table.getActiveTimeline().filterInflights().containsInstant(instantTime)) {
            table.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, table.getMetaClient().getCommitActionType(), instantTime), Option.empty(), config.shouldAllowMultiWriteOnSameInstant());
        }
        List<WriteStatus> writeStatuses = this.bulkInsert(inputRecords, instantTime, table, config, performDedupe, userDefinedBulkInsertPartitioner, false, config.getBulkInsertShuffleParallelism(), (WriteHandleFactory)new CreateHandleFactory(false));
        ((BaseJavaCommitActionExecutor)executor).updateIndexAndCommitIfNeeded(writeStatuses, result);
        return result;
    }

    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> inputRecords, String instantTime, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieWriteConfig config, boolean performDedupe, Option<BulkInsertPartitioner<T>> userDefinedBulkInsertPartitioner, boolean useWriterSchema, int parallelism, WriteHandleFactory writeHandleFactory) {
        List dedupedRecords = inputRecords;
        if (performDedupe) {
            dedupedRecords = (List)JavaWriteHelper.newInstance().combineOnCondition(config.shouldCombineBeforeInsert(), inputRecords, parallelism, table);
        }
        BulkInsertPartitioner partitioner = userDefinedBulkInsertPartitioner.isPresent() ? (BulkInsertPartitioner)userDefinedBulkInsertPartitioner.get() : JavaBulkInsertInternalPartitionerFactory.get(config.getBulkInsertSortMode());
        List repartitionedRecords = (List)partitioner.repartitionRecords((Object)dedupedRecords, parallelism);
        FileIdPrefixProvider fileIdPrefixProvider = (FileIdPrefixProvider)ReflectionUtils.loadClass((String)config.getFileIdPrefixProviderClassName(), (Object[])new Object[]{config.getProps()});
        ArrayList<WriteStatus> writeStatuses = new ArrayList<WriteStatus>();
        new JavaLazyInsertIterable(repartitionedRecords.iterator(), true, config, instantTime, table, fileIdPrefixProvider.createFilePrefix(""), table.getTaskContextSupplier(), (WriteHandleFactory)new CreateHandleFactory()).forEachRemaining(writeStatuses::addAll);
        return writeStatuses;
    }

    private static class BulkInsertHelperHolder {
        private static final JavaBulkInsertHelper JAVA_BULK_INSERT_HELPER = new JavaBulkInsertHelper();

        private BulkInsertHelperHolder() {
        }
    }
}

