/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieList;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.AbstractWriteHelper;

public class JavaWriteHelper<T extends HoodieRecordPayload, R>
extends AbstractWriteHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private JavaWriteHelper() {
    }

    public static JavaWriteHelper newInstance() {
        return WriteHelperHolder.JAVA_WRITE_HELPER;
    }

    protected List<HoodieRecord<T>> tag(List<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table) {
        return HoodieList.getList((HoodieData)table.getIndex().tagLocation((HoodieData)HoodieList.of(dedupedRecords), context, table));
    }

    public List<HoodieRecord<T>> deduplicateRecords(List<HoodieRecord<T>> records, HoodieIndex<T, ?, ?, ?> index, int parallelism) {
        boolean isIndexingGlobal = index.isGlobal();
        Map<Object, List<Pair>> keyedRecords = records.stream().map(record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of((Object)key, (Object)record);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        return keyedRecords.values().stream().map(x -> x.stream().map(Pair::getRight).reduce((rec1, rec2) -> {
            HoodieRecordPayload reducedData = rec1.getData().preCombine(rec2.getData());
            return new HoodieRecord(rec1.getKey(), reducedData);
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class WriteHelperHolder {
        private static final JavaWriteHelper JAVA_WRITE_HELPER = new JavaWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

