/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.ListBasedHoodieBloomIndexHelper;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.index.simple.HoodieGlobalSimpleIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;

public final class JavaHoodieIndexFactory {
    public static HoodieIndex createIndex(HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty((String)config.getIndexClass())) {
            return HoodieIndexUtils.createUserDefinedIndex((HoodieWriteConfig)config);
        }
        switch (config.getIndexType()) {
            case SIMPLE: {
                return new HoodieSimpleIndex(config, JavaHoodieIndexFactory.getKeyGeneratorForSimpleIndex(config));
            }
            case GLOBAL_SIMPLE: {
                return new HoodieGlobalSimpleIndex(config, JavaHoodieIndexFactory.getKeyGeneratorForSimpleIndex(config));
            }
            case INMEMORY: {
                return new HoodieInMemoryHashIndex(config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)ListBasedHoodieBloomIndexHelper.getInstance());
            }
        }
        throw new HoodieIndexException("Unsupported index type " + config.getIndexType());
    }

    private static Option<BaseKeyGenerator> getKeyGeneratorForSimpleIndex(HoodieWriteConfig config) {
        try {
            return config.populateMetaFields() ? Option.empty() : Option.of((Object)((BaseKeyGenerator)HoodieAvroKeyGeneratorFactory.createKeyGenerator((TypedProperties)config.getProps())));
        }
        catch (IOException e) {
            throw new HoodieIOException("KeyGenerator instantiation failed ", e);
        }
    }
}

