/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Comparator;
import java.util.List;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.BulkInsertPartitioner;

public class JavaHoodieMetadataBulkInsertPartitioner<T>
implements BulkInsertPartitioner<List<HoodieRecord<T>>> {
    private String fileId = null;

    public List<HoodieRecord<T>> repartitionRecords(List<HoodieRecord<T>> records, int outputPartitions) {
        if (records.isEmpty()) {
            return records;
        }
        records.sort(Comparator.comparing(record -> record.getKey().getRecordKey()));
        this.fileId = HoodieTableMetadataUtil.getFileGroupPrefix((String)records.get(0).getCurrentLocation().getFileId());
        return records;
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    public String getFileIdPfx(int partitionId) {
        return this.fileId == null ? super.getFileIdPfx(partitionId) : this.fileId;
    }
}

