/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaUpsertPartitioner;
import org.apache.hudi.table.action.commit.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJavaDeltaCommitActionExecutor<T>
extends BaseJavaCommitActionExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseJavaDeltaCommitActionExecutor.class);
    private JavaUpsertPartitioner partitioner;

    public BaseJavaDeltaCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType) {
        super(context, config, table, instantTime, operationType);
    }

    @Override
    public Partitioner getUpsertPartitioner(WorkloadProfile profile) {
        this.partitioner = (JavaUpsertPartitioner)super.getUpsertPartitioner(profile);
        return this.partitioner;
    }

    @Override
    public Iterator<List<WriteStatus>> handleUpdate(String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr) throws IOException {
        LOG.info("Merging updates for commit " + this.instantTime + " for file " + fileId);
        if (!this.table.getIndex().canIndexLogFiles() && this.partitioner != null && this.partitioner.getSmallFileIds().contains(fileId)) {
            LOG.info("Small file corrections for updates for commit " + this.instantTime + " for file " + fileId);
            return super.handleUpdate(partitionPath, fileId, recordItr);
        }
        HoodieAppendHandle appendHandle = new HoodieAppendHandle(this.config, this.instantTime, this.table, partitionPath, fileId, recordItr, this.taskContextSupplier);
        appendHandle.doAppend();
        return Collections.singletonList(appendHandle.close()).iterator();
    }
}

