// Autogenerated Jamon implementation
// /Users/stack/checkouts/hbase.git.commit/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RegionListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 24, 9
import java.util.*;
// 25, 9
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 26, 9
import org.apache.hadoop.hbase.util.Bytes;
// 27, 9
import org.apache.hadoop.hbase.HRegionInfo;
// 28, 9
import org.apache.hadoop.hbase.regionserver.Region;
// 29, 9
import org.apache.hadoop.hbase.ServerName;
// 30, 9
import org.apache.hadoop.hbase.HBaseConfiguration;
// 31, 9
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 32, 9
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos.ServerInfo;
// 33, 9
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos.RegionLoad;
// 34, 9
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
// 35, 9
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;

public class RegionListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.Intf

{
  private final HRegionServer regionServer;
  private final List<HRegionInfo> onlineRegions;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public RegionListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    onlineRegions = p_implData.getOnlineRegions();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 37, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 37, 60
      jamonWriter.write("\n\n    ");
      // 39, 5
      
        Collections.sort(onlineRegions);
    
      // 43, 5
      jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\">\n            <li class=\"active\"><a href=\"#tab_regionBaseInfo\" data-toggle=\"tab\">Base Info</a> </li>\n            <li><a href=\"#tab_regionRequestStats\" data-toggle=\"tab\">Request metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionStoreStats\" data-toggle=\"tab\">Storefile Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionMemstoreStats\" data-toggle=\"tab\">Memstore Metrics</a></li>\n            <li class=\"\"><a href=\"#tab_regionCompactStats\" data-toggle=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\">\n                ");
      // 53, 17
      {
        // 53, 17
        __jamon_innerUnit__baseInfo(jamonWriter, onlineRegions);
      }
      // 53, 63
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\">\n                ");
      // 56, 17
      {
        // 56, 17
        __jamon_innerUnit__requestStats(jamonWriter, onlineRegions);
      }
      // 56, 67
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\">\n                ");
      // 59, 17
      {
        // 59, 17
        __jamon_innerUnit__storeStats(jamonWriter, onlineRegions);
      }
      // 59, 65
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\">\n                ");
      // 62, 17
      {
        // 62, 17
        __jamon_innerUnit__memstoreStats(jamonWriter, onlineRegions);
      }
      // 62, 68
      jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\">\n                ");
      // 65, 17
      {
        // 65, 17
        __jamon_innerUnit__compactStats(jamonWriter, onlineRegions);
      }
      // 65, 67
      jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 80, 1
    else
    {
      // 80, 8
      jamonWriter.write("\n    <p>Not serving regions</p>\n");
    }
    // 82, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 109, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 113, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Read Request Count</th>\n            <th>Write Request Count</th>\n        </tr>\n\n        ");
    // 120, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 120, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 123, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 126, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 126, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 126, 66
      jamonWriter.write("\">\n              ");
      // 127, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 127, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 129, 13
      if (load != null )
      {
        // 129, 33
        jamonWriter.write("\n            <td>");
        // 130, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getReadRequestsCount()), jamonWriter);
        // 130, 50
        jamonWriter.write("</td>\n            <td>");
        // 131, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getWriteRequestsCount()), jamonWriter);
        // 131, 51
        jamonWriter.write("</td>\n            ");
      }
      // 132, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 134, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 215, 1
  private void __jamon_innerUnit__memstoreStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 219, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Memstore Size</th>\n        </tr>\n\n        ");
    // 225, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 225, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 228, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 231, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 231, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 231, 66
      jamonWriter.write("\">\n              ");
      // 232, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 232, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 234, 13
      if (load != null )
      {
        // 234, 33
        jamonWriter.write("\n            <td>");
        // 235, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getMemstoreSizeMB()), jamonWriter);
        // 235, 47
        jamonWriter.write("m</td>\n            ");
      }
      // 236, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 238, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 179, 1
  private void __jamon_innerUnit__compactStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 183, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Compacting KVs</th>\n            <th>Num. Compacted KVs</th>\n            <th>Compaction Progress</th>\n        </tr>\n\n        ");
    // 191, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 191, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 194, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            if  (load != null && load.getTotalCompactingKVs() > 0) {
            percentDone = String.format("%.2f", 100 *
            ((float) load.getCurrentCompactedKVs() / load.getTotalCompactingKVs())) + "%";
            }
        
      // 202, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 202, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 202, 66
      jamonWriter.write("\">\n              ");
      // 203, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 203, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 205, 13
      if (load != null )
      {
        // 205, 33
        jamonWriter.write("\n            <td>");
        // 206, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalCompactingKVs()), jamonWriter);
        // 206, 51
        jamonWriter.write("</td>\n            <td>");
        // 207, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getCurrentCompactedKVs()), jamonWriter);
        // 207, 52
        jamonWriter.write("</td>\n            <td>");
        // 208, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
        // 208, 34
        jamonWriter.write("</td>\n            ");
      }
      // 209, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 211, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 84, 1
  private void __jamon_innerUnit__baseInfo(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 88, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Start Key</th>\n            <th>End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n\n        ");
    // 96, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 96, 46
      jamonWriter.write("\n        <tr>\n            <td><a href=\"region.jsp?name=");
      // 98, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 98, 66
      jamonWriter.write("\">\n              ");
      // 99, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 99, 46
      jamonWriter.write("</a>\n            </td>\n            <td>");
      // 101, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
      // 101, 60
      jamonWriter.write("</td>\n            <td>");
      // 102, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
      // 102, 58
      jamonWriter.write("</td>\n            <td>");
      // 103, 17
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getReplicaId()), jamonWriter);
      // 103, 39
      jamonWriter.write("</td>\n        </tr>\n        ");
    }
    // 105, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
  // 139, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final List<HRegionInfo> onlineRegions)
    throws java.io.IOException
  {
    // 143, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>Region Name</th>\n            <th>Num. Stores</th>\n            <th>Num. Storefiles</th>\n            <th>Storefile Size Uncompressed</th>\n            <th>Storefile Size</th>\n            <th>Index Size</th>\n            <th>Bloom Size</th>\n            <th>Data Locality</th>\n        </tr>\n\n        ");
    // 155, 9
    for (HRegionInfo r: onlineRegions )
    {
      // 155, 46
      jamonWriter.write("\n\n        <tr>\n        ");
      // 158, 9
      
            RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());
        
      // 161, 13
      jamonWriter.write("<td><a href=\"region.jsp?name=");
      // 161, 42
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getEncodedName()), jamonWriter);
      // 161, 66
      jamonWriter.write("\">\n              ");
      // 162, 15
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
      // 162, 46
      jamonWriter.write("</a>\n            </td>\n            ");
      // 164, 13
      if (load != null )
      {
        // 164, 33
        jamonWriter.write("\n            <td>");
        // 165, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStores()), jamonWriter);
        // 165, 39
        jamonWriter.write("</td>\n            <td>");
        // 166, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefiles()), jamonWriter);
        // 166, 43
        jamonWriter.write("</td>\n            <td>");
        // 167, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStoreUncompressedSizeMB()), jamonWriter);
        // 167, 56
        jamonWriter.write("m</td>\n            <td>");
        // 168, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getStorefileSizeMB()), jamonWriter);
        // 168, 48
        jamonWriter.write("m</td>\n            <td>");
        // 169, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticIndexSizeKB()), jamonWriter);
        // 169, 55
        jamonWriter.write("k</td>\n            <td>");
        // 170, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getTotalStaticBloomSizeKB()), jamonWriter);
        // 170, 55
        jamonWriter.write("k</td>\n            <td>");
        // 171, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load.getDataLocality()), jamonWriter);
        // 171, 45
        jamonWriter.write("</td>\n            ");
      }
      // 172, 19
      jamonWriter.write("\n        </tr>\n        ");
    }
    // 174, 16
    jamonWriter.write("\n    </table>\n");
  }
  
  
}
