/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.common.HadoopOutputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyProgressable;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyReporter;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

@Internal
public abstract class HadoopOutputFormatBase<K, V, T>
extends HadoopOutputFormatCommonBase<T>
implements FinalizeOnMaster {
    private static final long serialVersionUID = 1L;
    protected static final Object OPEN_MUTEX = new Object();
    protected static final Object CONFIGURE_MUTEX = new Object();
    protected static final Object CLOSE_MUTEX = new Object();
    protected JobConf jobConf;
    protected OutputFormat<K, V> mapredOutputFormat;
    protected transient RecordWriter<K, V> recordWriter;
    protected transient OutputCommitter outputCommitter;
    protected transient TaskAttemptContext context;

    public HadoopOutputFormatBase(OutputFormat<K, V> mapredOutputFormat, JobConf job) {
        super(job.getCredentials());
        this.mapredOutputFormat = mapredOutputFormat;
        HadoopUtils.mergeHadoopConf(job);
        this.jobConf = job;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Configuration parameters) {
        Object object = CONFIGURE_MUTEX;
        synchronized (object) {
            if (this.mapredOutputFormat instanceof Configurable) {
                ((Configurable)this.mapredOutputFormat).setConf((org.apache.hadoop.conf.Configuration)this.jobConf);
            } else if (this.mapredOutputFormat instanceof JobConfigurable) {
                ((JobConfigurable)this.mapredOutputFormat).configure(this.jobConf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        Object object = OPEN_MUTEX;
        synchronized (object) {
            if (Integer.toString(taskNumber + 1).length() > 6) {
                throw new IOException("Task id too large.");
            }
            TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)("attempt__0000_r_" + String.format("%" + (6 - Integer.toString(taskNumber + 1).length()) + "s", " ").replace(" ", "0") + Integer.toString(taskNumber + 1) + "_0"));
            this.jobConf.set("mapred.task.id", taskAttemptID.toString());
            this.jobConf.setInt("mapred.task.partition", taskNumber + 1);
            this.jobConf.set("mapreduce.task.attempt.id", taskAttemptID.toString());
            this.jobConf.setInt("mapreduce.task.partition", taskNumber + 1);
            this.context = new TaskAttemptContextImpl(this.jobConf, taskAttemptID);
            this.outputCommitter = this.jobConf.getOutputCommitter();
            JobContextImpl jobContext = new JobContextImpl(this.jobConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
            this.outputCommitter.setupJob((JobContext)jobContext);
            this.recordWriter = this.mapredOutputFormat.getRecordWriter(null, this.jobConf, Integer.toString(taskNumber + 1), (Progressable)new HadoopDummyProgressable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = CLOSE_MUTEX;
        synchronized (object) {
            this.recordWriter.close((Reporter)new HadoopDummyReporter());
            if (this.outputCommitter.needsTaskCommit(this.context)) {
                this.outputCommitter.commitTask(this.context);
            }
        }
    }

    @Override
    public void finalizeGlobal(int parallelism) throws IOException {
        try {
            JobContextImpl jobContext = new JobContextImpl(this.jobConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
            OutputCommitter outputCommitter = this.jobConf.getOutputCommitter();
            outputCommitter.commitJob((JobContext)jobContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeUTF(this.mapredOutputFormat.getClass().getName());
        this.jobConf.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        String hadoopOutputFormatName = in.readUTF();
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        try {
            this.mapredOutputFormat = (OutputFormat)Class.forName(hadoopOutputFormatName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop output format", e);
        }
        ReflectionUtils.setConf(this.mapredOutputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
        this.jobConf.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HadoopInputFormatCommonBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            this.jobConf.getCredentials().addAll(currentUserCreds);
        }
    }
}

