/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

@Internal
final class PojoFieldUtils {
    PojoFieldUtils() {
    }

    static void writeField(DataOutputView out, Field field2) throws IOException {
        Class<?> declaringClass = field2.getDeclaringClass();
        out.writeUTF(declaringClass.getName());
        out.writeUTF(field2.getName());
    }

    static Field readField(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        Class declaringClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
        String fieldName = in.readUTF();
        return PojoFieldUtils.getField(fieldName, declaringClass);
    }

    @Nullable
    static Field getField(String fieldName, Class<?> declaringClass) {
        for (Class<?> clazz = declaringClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field2 = clazz.getDeclaredField(fieldName);
                field2.setAccessible(true);
                return field2;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

