/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.DataInput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.Writable;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class WritableComparator<T extends Writable & Comparable<T>>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private Class<T> type;
    private final boolean ascendingComparison;
    private transient T reference;
    private transient T tempReference;
    private transient Kryo kryo;
    private final TypeComparator[] comparators = new TypeComparator[]{this};

    public WritableComparator(boolean ascending, Class<T> type) {
        this.type = type;
        this.ascendingComparison = ascending;
    }

    @Override
    public int hash(T record) {
        return record.hashCode();
    }

    @Override
    public void setReference(T toCompare) {
        this.checkKryoInitialized();
        this.reference = (Writable)KryoUtils.copy(toCompare, this.kryo, new WritableSerializer<T>(this.type));
    }

    @Override
    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<T> referencedComparator) {
        T otherRef = ((WritableComparator)referencedComparator).reference;
        int comp = ((Comparable)otherRef).compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(T first, T second) {
        int comp = ((Comparable)first).compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.ensureReferenceInstantiated();
        this.ensureTempReferenceInstantiated();
        this.reference.readFields((DataInput)firstSource);
        this.tempReference.readFields((DataInput)secondSource);
        int comp = ((Comparable)this.reference).compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(this.type);
    }

    @Override
    public int getNormalizeKeyLen() {
        this.ensureReferenceInstantiated();
        NormalizableKey key = (NormalizableKey)this.reference;
        return key.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)record;
        key.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<T> duplicate() {
        return new WritableComparator<T>(this.ascendingComparison, this.type);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy(new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy(instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    private void ensureReferenceInstantiated() {
        if (this.reference == null) {
            this.reference = InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }

    private void ensureTempReferenceInstantiated() {
        if (this.tempReference == null) {
            this.tempReference = InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }
}

