/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;
import sun.misc.Unsafe;

@Public
public final class Record
implements Value,
CopyableValue<Record> {
    private static final long serialVersionUID = 1L;
    private static final int NULL_INDICATOR_OFFSET = Integer.MIN_VALUE;
    private static final int MODIFIED_INDICATOR_OFFSET = -2147483647;
    private static final int DEFAULT_FIELD_LEN_ESTIMATE = 8;
    private final InternalDeSerializer serializer = new InternalDeSerializer();
    private byte[] binaryData;
    private byte[] switchBuffer;
    private int[] offsets;
    private int[] lengths;
    private Value[] readFields;
    private Value[] writeFields;
    private int binaryLen;
    private int numFields;
    private int firstModifiedPos;
    private static final int MAX_BIT = 128;
    private static final Value RESERVE_SPACE = new Value(){
        private static final long serialVersionUID = 1L;

        @Override
        public void write(DataOutputView out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void read(DataInputView in) throws IOException {
            throw new UnsupportedOperationException();
        }
    };

    public Record() {
    }

    public Record(Value value) {
        this.setField(0, value);
    }

    public Record(Value val1, Value val2) {
        this.makeSpace(2);
        this.setField(0, val1);
        this.setField(1, val2);
    }

    public Record(int numFields) {
        this.setNumFields(numFields);
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int numFields) {
        int oldNumFields = this.numFields;
        if (numFields > oldNumFields) {
            this.makeSpace(numFields);
            for (int i = oldNumFields; i < numFields; ++i) {
                this.offsets[i] = Integer.MIN_VALUE;
            }
            this.markModified(oldNumFields);
        } else {
            this.markModified(numFields);
        }
        this.numFields = numFields;
    }

    public void makeSpace(int numFields) {
        Value[] newFields;
        int oldNumFields = this.numFields;
        if (this.offsets == null) {
            this.offsets = new int[numFields];
        } else if (this.offsets.length < numFields) {
            int[] newOffs = new int[Math.max(numFields + 1, oldNumFields << 1)];
            System.arraycopy(this.offsets, 0, newOffs, 0, oldNumFields);
            this.offsets = newOffs;
        }
        if (this.lengths == null) {
            this.lengths = new int[numFields];
        } else if (this.lengths.length < numFields) {
            int[] newLens = new int[Math.max(numFields + 1, oldNumFields << 1)];
            System.arraycopy(this.lengths, 0, newLens, 0, oldNumFields);
            this.lengths = newLens;
        }
        if (this.readFields == null) {
            this.readFields = new Value[numFields];
        } else if (this.readFields.length < numFields) {
            newFields = new Value[Math.max(numFields + 1, oldNumFields << 1)];
            System.arraycopy(this.readFields, 0, newFields, 0, oldNumFields);
            this.readFields = newFields;
        }
        if (this.writeFields == null) {
            this.writeFields = new Value[numFields];
        } else if (this.writeFields.length < numFields) {
            newFields = new Value[Math.max(numFields + 1, oldNumFields << 1)];
            System.arraycopy(this.writeFields, 0, newFields, 0, oldNumFields);
            this.writeFields = newFields;
        }
    }

    public <T extends Value> T getField(int fieldNum, Class<T> type) {
        Value field2;
        if (fieldNum < 0 || fieldNum >= this.numFields) {
            throw new IndexOutOfBoundsException(fieldNum + " for range [0.." + (this.numFields - 1) + "]");
        }
        int offset = this.offsets[fieldNum];
        if (offset == Integer.MIN_VALUE) {
            return null;
        }
        if (offset == -2147483647) {
            return (T)this.writeFields[fieldNum];
        }
        int limit = offset + this.lengths[fieldNum];
        Value oldField = this.readFields[fieldNum];
        if (oldField != null && oldField.getClass() == type) {
            field2 = oldField;
        } else {
            this.readFields[fieldNum] = field2 = InstantiationUtil.instantiate(type, Value.class);
        }
        this.deserialize(field2, offset, limit, fieldNum);
        return (T)field2;
    }

    public <T extends Value> T getField(int fieldNum, T target) {
        if (fieldNum < 0 || fieldNum >= this.numFields) {
            throw new IndexOutOfBoundsException();
        }
        if (target == null) {
            throw new NullPointerException("The target object may not be null");
        }
        int offset = this.offsets[fieldNum];
        if (offset == Integer.MIN_VALUE) {
            return null;
        }
        if (offset == -2147483647) {
            return (T)this.writeFields[fieldNum];
        }
        int limit = offset + this.lengths[fieldNum];
        this.deserialize(target, offset, limit, fieldNum);
        return target;
    }

    public boolean getFieldInto(int fieldNum, Value target) {
        if (fieldNum < 0 || fieldNum >= this.numFields) {
            throw new IndexOutOfBoundsException();
        }
        int offset = this.offsets[fieldNum];
        if (offset == Integer.MIN_VALUE) {
            return false;
        }
        if (offset == -2147483647) {
            this.updateBinaryRepresenation();
            offset = this.offsets[fieldNum];
        }
        int limit = offset + this.lengths[fieldNum];
        this.deserialize(target, offset, limit, fieldNum);
        return true;
    }

    public boolean getFieldsInto(int[] positions, Value[] targets) {
        for (int i = 0; i < positions.length; ++i) {
            if (this.getFieldInto(positions[i], targets[i])) continue;
            return false;
        }
        return true;
    }

    public void getFieldsIntoCheckingNull(int[] positions, Value[] targets) {
        for (int i = 0; i < positions.length; ++i) {
            if (this.getFieldInto(positions[i], targets[i])) continue;
            throw new NullKeyFieldException(i);
        }
    }

    private <T extends Value> void deserialize(T target, int offset, int limit, int fieldNumber) {
        InternalDeSerializer serializer = this.serializer;
        InternalDeSerializer.access$102(serializer, this.binaryData);
        serializer.position = offset;
        serializer.end = limit;
        try {
            target.read(serializer);
        }
        catch (Exception e) {
            throw new DeserializationException("Error reading field " + fieldNumber + " as " + target.getClass().getName(), e);
        }
    }

    public void setField(int fieldNum, Value value) {
        if (fieldNum < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (fieldNum >= this.numFields) {
            this.setNumFields(fieldNum + 1);
        }
        this.internallySetField(fieldNum, value);
    }

    public void addField(Value value) {
        int num = this.numFields;
        this.setNumFields(num + 1);
        this.internallySetField(num, value);
    }

    private void internallySetField(int fieldNum, Value value) {
        this.offsets[fieldNum] = value != null ? -2147483647 : Integer.MIN_VALUE;
        this.writeFields[fieldNum] = value;
        this.markModified(fieldNum);
    }

    private void markModified(int field2) {
        if (this.firstModifiedPos > field2) {
            this.firstModifiedPos = field2;
        }
    }

    private boolean isModified() {
        return this.firstModifiedPos != Integer.MAX_VALUE;
    }

    public void removeField(int fieldNum) {
        if (fieldNum < 0 || fieldNum >= this.numFields) {
            throw new IndexOutOfBoundsException();
        }
        int lastIndex = this.numFields - 1;
        if (fieldNum < lastIndex) {
            int len = lastIndex - fieldNum;
            System.arraycopy(this.offsets, fieldNum + 1, this.offsets, fieldNum, len);
            System.arraycopy(this.lengths, fieldNum + 1, this.lengths, fieldNum, len);
            System.arraycopy(this.readFields, fieldNum + 1, this.readFields, fieldNum, len);
            System.arraycopy(this.writeFields, fieldNum + 1, this.writeFields, fieldNum, len);
            this.markModified(fieldNum);
        }
        this.offsets[lastIndex] = Integer.MIN_VALUE;
        this.lengths[lastIndex] = 0;
        this.writeFields[lastIndex] = null;
        this.setNumFields(lastIndex);
    }

    public final boolean isNull(int fieldNum) {
        if (fieldNum < 0 || fieldNum >= this.numFields) {
            throw new IndexOutOfBoundsException();
        }
        int offset = this.offsets[fieldNum];
        return offset == Integer.MIN_VALUE;
    }

    public void setNull(int field2) {
        if (field2 < 0 || field2 >= this.numFields) {
            throw new IndexOutOfBoundsException();
        }
        this.internallySetField(field2, null);
    }

    public void setNull(long mask) {
        int i = 0;
        while (i < this.numFields) {
            if ((mask & 1L) != 0L) {
                this.internallySetField(i, null);
            }
            ++i;
            mask >>>= 1;
        }
    }

    public void setNull(long[] mask) {
        int maskPos = 0;
        int i = 0;
        while (i < this.numFields) {
            long currMask = mask[maskPos];
            int k = 64;
            while (i < this.numFields && k > 0) {
                if ((currMask & 1L) != 0L) {
                    this.internallySetField(i, null);
                }
                --k;
                ++i;
                currMask >>>= 1;
            }
        }
    }

    public void clear() {
        if (this.numFields > 0) {
            this.numFields = 0;
            this.firstModifiedPos = 0;
        }
    }

    public void concatenate(Record record) {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    public void unionFields(Record other) {
        minFields = Math.min(this.numFields, other.numFields);
        maxFields = Math.max(this.numFields, other.numFields);
        offsets = this.offsets.length >= maxFields ? this.offsets : new int[maxFields];
        v0 = lengths = this.lengths.length >= maxFields ? this.lengths : new int[maxFields];
        if (!this.isModified() && !other.isModified()) {
            estimatedLength = this.binaryLen + other.binaryLen;
            InternalDeSerializer.access$102(this.serializer, this.switchBuffer != null && this.switchBuffer.length >= estimatedLength ? this.switchBuffer : new byte[estimatedLength]);
            InternalDeSerializer.access$202(this.serializer, 0);
            try {
                for (i = 0; i < minFields; ++i) {
                    thisOff = this.offsets[i];
                    if (thisOff == -2147483648) {
                        otherOff = other.offsets[i];
                        if (otherOff == -2147483648) {
                            offsets[i] = -2147483648;
                            continue;
                        }
                        offsets[i] = InternalDeSerializer.access$200(this.serializer);
                        this.serializer.write(other.binaryData, otherOff, other.lengths[i]);
                        lengths[i] = other.lengths[i];
                        continue;
                    }
                    offsets[i] = InternalDeSerializer.access$200(this.serializer);
                    this.serializer.write(this.binaryData, thisOff, this.lengths[i]);
                    lengths[i] = this.lengths[i];
                }
                if (minFields == maxFields) ** GOTO lbl101
                sourceForRemainder = this.numFields > minFields ? this : other;
                begin = -1;
                end = -1;
                offsetDelta = 0;
                for (k = minFields; k < maxFields; ++k) {
                    off = sourceForRemainder.offsets[k];
                    if (off == -2147483648) {
                        offsets[k] = -2147483648;
                        continue;
                    }
                    end = sourceForRemainder.offsets[k] + sourceForRemainder.lengths[k];
                    if (begin == -1) {
                        begin = sourceForRemainder.offsets[k];
                        offsetDelta = InternalDeSerializer.access$200(this.serializer) - begin;
                    }
                    offsets[k] = sourceForRemainder.offsets[k] + offsetDelta;
                }
                if (begin != -1) {
                    this.serializer.write(sourceForRemainder.binaryData, begin, end - begin);
                }
                if (lengths == sourceForRemainder.lengths) ** GOTO lbl101
                System.arraycopy(sourceForRemainder.lengths, minFields, lengths, minFields, maxFields - minFields);
            }
            catch (Exception ioex) {
                throw new RuntimeException("Error creating field union of record data" + ioex.getMessage() == null ? "." : ": " + ioex.getMessage(), ioex);
            }
        } else {
            estimatedLength = (this.binaryLen > 0 ? this.binaryLen : this.numFields * 8) + (other.binaryLen > 0 ? other.binaryLen : other.numFields * 8);
            InternalDeSerializer.access$102(this.serializer, this.switchBuffer != null && this.switchBuffer.length >= estimatedLength ? this.switchBuffer : new byte[estimatedLength]);
            InternalDeSerializer.access$202(this.serializer, 0);
            try {
                for (i = 0; i < minFields; ++i) {
                    thisOff = this.offsets[i];
                    if (thisOff == -2147483648) {
                        otherOff = other.offsets[i];
                        if (otherOff == -2147483648) {
                            offsets[i] = -2147483648;
                            continue;
                        }
                        if (otherOff == -2147483647) {
                            offsets[i] = InternalDeSerializer.access$200(this.serializer);
                            other.writeFields[i].write(this.serializer);
                            lengths[i] = InternalDeSerializer.access$200(this.serializer) - offsets[i];
                            continue;
                        }
                        offsets[i] = InternalDeSerializer.access$200(this.serializer);
                        this.serializer.write(other.binaryData, otherOff, other.lengths[i]);
                        lengths[i] = other.lengths[i];
                        continue;
                    }
                    if (thisOff == -2147483647) {
                        offsets[i] = InternalDeSerializer.access$200(this.serializer);
                        this.writeFields[i].write(this.serializer);
                        lengths[i] = InternalDeSerializer.access$200(this.serializer) - offsets[i];
                        continue;
                    }
                    offsets[i] = InternalDeSerializer.access$200(this.serializer);
                    this.serializer.write(this.binaryData, thisOff, this.lengths[i]);
                    lengths[i] = this.lengths[i];
                }
                if (minFields != maxFields) {
                    sourceForRemainder = this.numFields > minFields ? this : other;
                    for (k = minFields; k < maxFields; ++k) {
                        off = sourceForRemainder.offsets[k];
                        if (off == -2147483648) {
                            offsets[k] = -2147483648;
                            continue;
                        }
                        if (off == -2147483647) {
                            offsets[k] = InternalDeSerializer.access$200(this.serializer);
                            sourceForRemainder.writeFields[k].write(this.serializer);
                            lengths[k] = InternalDeSerializer.access$200(this.serializer) - offsets[k];
                            continue;
                        }
                        offsets[k] = InternalDeSerializer.access$200(this.serializer);
                        len = sourceForRemainder.lengths[k];
                        this.serializer.write(sourceForRemainder.binaryData, off, len);
                        lengths[k] = len;
                    }
                }
            }
            catch (Exception ioex) {
                throw new RuntimeException("Error creating field union of record data" + ioex.getMessage() == null ? "." : ": " + ioex.getMessage(), ioex);
            }
        }
lbl101:
        // 4 sources

        this.serializeHeader(this.serializer, offsets, maxFields);
        this.switchBuffer = this.binaryData;
        this.binaryData = InternalDeSerializer.access$100(this.serializer);
        this.binaryLen = InternalDeSerializer.access$200(this.serializer);
        this.numFields = maxFields;
        this.offsets = offsets;
        this.lengths = lengths;
        this.firstModifiedPos = 0x7FFFFFFF;
        if (this.readFields == null || this.readFields.length < maxFields) {
            na = new Value[maxFields];
            System.arraycopy(this.readFields, 0, na, 0, this.readFields.length);
            this.readFields = na;
        }
        this.writeFields = this.writeFields == null || this.writeFields.length < maxFields ? new Value[maxFields] : this.writeFields;
    }

    @Override
    public void copyTo(Record target) {
        this.updateBinaryRepresenation();
        if (target.binaryData == null || target.binaryData.length < this.binaryLen) {
            target.binaryData = new byte[this.binaryLen];
        }
        if (target.offsets == null || target.offsets.length < this.numFields) {
            target.offsets = new int[this.numFields];
        }
        if (target.lengths == null || target.lengths.length < this.numFields) {
            target.lengths = new int[this.numFields];
        }
        if (target.readFields == null || target.readFields.length < this.numFields) {
            target.readFields = new Value[this.numFields];
        }
        if (target.writeFields == null || target.writeFields.length < this.numFields) {
            target.writeFields = new Value[this.numFields];
        }
        System.arraycopy(this.binaryData, 0, target.binaryData, 0, this.binaryLen);
        System.arraycopy(this.offsets, 0, target.offsets, 0, this.numFields);
        System.arraycopy(this.lengths, 0, target.lengths, 0, this.numFields);
        target.binaryLen = this.binaryLen;
        target.numFields = this.numFields;
        target.firstModifiedPos = Integer.MAX_VALUE;
    }

    @Override
    public int getBinaryLength() {
        return -1;
    }

    @Override
    public Record copy() {
        return this.createCopy();
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int val = source.readUnsignedByte();
        target.writeByte(val);
        if (val >= 128) {
            int curr;
            int shift = 7;
            val &= 0x7F;
            while ((curr = source.readUnsignedByte()) >= 128) {
                target.writeByte(curr);
                val |= (curr & 0x7F) << shift;
                shift += 7;
            }
            target.writeByte(curr);
            val |= curr << shift;
        }
        target.write(source, val);
    }

    public Record createCopy() {
        Record rec = new Record();
        this.copyTo(rec);
        return rec;
    }

    public void copyFrom(Record source, int[] sourcePositions, int[] targetPositions) {
        int[] sourceOffsets = source.offsets;
        int[] sourceLengths = source.lengths;
        byte[] sourceBuffer = source.binaryData;
        Value[] sourceFields = source.writeFields;
        boolean anyFieldIsBinary = false;
        int maxFieldNum = 0;
        for (int i = 0; i < sourcePositions.length; ++i) {
            int sourceFieldNum = sourcePositions[i];
            int sourceOffset = sourceOffsets[sourceFieldNum];
            int targetFieldNum = targetPositions[i];
            maxFieldNum = Math.max(targetFieldNum, maxFieldNum);
            if (sourceOffset == Integer.MIN_VALUE) {
                if (targetFieldNum >= this.numFields) continue;
                this.internallySetField(targetFieldNum, null);
                continue;
            }
            if (sourceOffset == -2147483647) continue;
            anyFieldIsBinary = true;
        }
        if (this.numFields < maxFieldNum + 1) {
            this.setNumFields(maxFieldNum + 1);
        }
        int[] targetLengths = this.lengths;
        int[] targetOffsets = this.offsets;
        if (anyFieldIsBinary) {
            for (int i = 0; i < sourcePositions.length; ++i) {
                int sourceFieldNum = sourcePositions[i];
                int sourceOffset = sourceOffsets[sourceFieldNum];
                if (sourceOffset == -2147483647 || sourceOffset == Integer.MIN_VALUE) continue;
                int targetFieldNum = targetPositions[i];
                targetLengths[targetFieldNum] = sourceLengths[sourceFieldNum];
                this.internallySetField(targetFieldNum, RESERVE_SPACE);
            }
            this.updateBinaryRepresenation();
        }
        byte[] targetBuffer = this.binaryData;
        for (int i = 0; i < sourcePositions.length; ++i) {
            int sourceFieldNum = sourcePositions[i];
            int sourceOffset = sourceOffsets[sourceFieldNum];
            int targetFieldNum = targetPositions[i];
            if (sourceOffset == -2147483647) {
                this.internallySetField(targetFieldNum, sourceFields[sourceFieldNum]);
                continue;
            }
            if (sourceOffset == Integer.MIN_VALUE) continue;
            int targetOffset = targetOffsets[targetFieldNum];
            int length = targetLengths[targetFieldNum];
            System.arraycopy(sourceBuffer, sourceOffset, targetBuffer, targetOffset, length);
        }
    }

    public final boolean equalsFields(int[] positions, Value[] searchValues, Value[] deserializationHolders) {
        for (int i = 0; i < positions.length; ++i) {
            Value v = this.getField(positions[i], deserializationHolders[i]);
            if (v != null && v.equals(searchValues[i])) continue;
            return false;
        }
        return true;
    }

    public void updateBinaryRepresenation() {
        int firstModified = this.firstModifiedPos;
        if (firstModified == Integer.MAX_VALUE) {
            return;
        }
        InternalDeSerializer serializer = this.serializer;
        int[] offsets = this.offsets;
        int numFields = this.numFields;
        InternalDeSerializer.access$102(serializer, this.switchBuffer != null ? this.switchBuffer : (this.binaryLen > 0 ? new byte[this.binaryLen] : new byte[numFields * 8 + 1]));
        serializer.position = 0;
        if (numFields > 0) {
            int i;
            int offset = 0;
            if (firstModified > 0) {
                for (i = firstModified - 1; i >= 0; --i) {
                    if (this.offsets[i] == Integer.MIN_VALUE) continue;
                    offset = this.offsets[i] + this.lengths[i];
                    break;
                }
            }
            try {
                if (offset > 0) {
                    serializer.write(this.binaryData, 0, offset);
                }
                for (i = firstModified; i < numFields; ++i) {
                    int co = offsets[i];
                    if (co == Integer.MIN_VALUE) continue;
                    offsets[i] = offset;
                    if (co == -2147483647) {
                        Value writeField = this.writeFields[i];
                        if (writeField == RESERVE_SPACE) {
                            int length = this.lengths[i];
                            if (serializer.position >= serializer.memory.length - length - 1) {
                                serializer.resize(length);
                            }
                            serializer.position = serializer.position + length;
                        } else {
                            this.writeFields[i].write(serializer);
                        }
                    } else {
                        serializer.write(this.binaryData, co, this.lengths[i]);
                    }
                    this.lengths[i] = serializer.position - offset;
                    offset = serializer.position;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in data type serialization: " + e.getMessage(), e);
            }
        }
        this.serializeHeader(serializer, offsets, numFields);
        this.switchBuffer = this.binaryData;
        this.binaryData = serializer.memory;
        this.binaryLen = serializer.position;
        this.firstModifiedPos = Integer.MAX_VALUE;
    }

    private void serializeHeader(InternalDeSerializer serializer, int[] offsets, int numFields) {
        try {
            if (numFields > 0) {
                int slp = serializer.position;
                if (numFields <= 8) {
                    int mask = 0;
                    for (int i = numFields - 1; i > 0; --i) {
                        if (offsets[i] != Integer.MIN_VALUE) {
                            slp = serializer.position;
                            serializer.writeValLenIntBackwards(offsets[i]);
                            mask |= 1;
                        }
                        mask <<= 1;
                    }
                    if (offsets[0] != Integer.MIN_VALUE) {
                        mask |= 1;
                    } else {
                        serializer.position = slp;
                    }
                    serializer.writeByte(mask);
                } else {
                    for (int i = numFields - 1; i > 0; --i) {
                        if (offsets[i] == Integer.MIN_VALUE) continue;
                        slp = serializer.position;
                        serializer.writeValLenIntBackwards(offsets[i]);
                    }
                    if (offsets[0] == Integer.MIN_VALUE) {
                        serializer.position = slp;
                    }
                    int col = numFields - 1;
                    int mask = 0;
                    int i = numFields & 7;
                    if (i > 0) {
                        while (i > 0) {
                            mask <<= 1;
                            mask |= offsets[col] != Integer.MIN_VALUE ? 1 : 0;
                            --i;
                            --col;
                        }
                        serializer.writeByte(mask);
                    }
                    for (i = numFields >>> 3; i > 0; --i) {
                        mask = 0;
                        int k = 0;
                        while (k < 8) {
                            mask <<= 1;
                            mask |= offsets[col] != Integer.MIN_VALUE ? 1 : 0;
                            ++k;
                            --col;
                        }
                        serializer.writeByte(mask);
                    }
                }
            }
            serializer.writeValLenIntBackwards(numFields);
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing Record header: " + e.getMessage(), e);
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        this.updateBinaryRepresenation();
        Record.writeVarLengthInt(out, this.binaryLen);
        out.write(this.binaryData, 0, this.binaryLen);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        int len;
        this.binaryLen = len = Record.readVarLengthInt(in);
        byte[] data = this.binaryData;
        if (data == null || data.length < len) {
            this.binaryData = data = new byte[len];
        }
        in.readFully(data, 0, len);
        this.initFields(data, 0, len);
    }

    private void initFields(byte[] data, int begin, int len) {
        try {
            int pos = begin + len - 2;
            int numFields = data[begin + len - 1] & 0xFF;
            if (numFields >= 128) {
                int curr;
                int shift = 7;
                numFields &= 0x7F;
                while ((curr = data[pos--] & 0xFF) >= 128) {
                    numFields |= (curr & 0x7F) << shift;
                    shift += 7;
                }
                numFields |= curr << shift;
            }
            this.numFields = numFields;
            if (this.offsets == null || this.offsets.length < numFields) {
                this.offsets = new int[numFields];
            }
            if (this.lengths == null || this.lengths.length < numFields) {
                this.lengths = new int[numFields];
            }
            if (this.readFields == null || this.readFields.length < numFields) {
                this.readFields = new Value[numFields];
            }
            if (this.writeFields == null || this.writeFields.length < numFields) {
                this.writeFields = new Value[numFields];
            }
            int beginMasks = pos;
            int fieldsBy8 = (numFields >>> 3) + ((numFields & 7) == 0 ? 0 : 1);
            pos = beginMasks - fieldsBy8;
            int lastNonNullField = -1;
            int field2 = 0;
            for (int chunk = 0; chunk < fieldsBy8; ++chunk) {
                int mask = data[beginMasks - chunk];
                for (int i = 0; i < 8 && field2 < numFields; ++i, ++field2) {
                    if ((mask & 1) == 1) {
                        if (lastNonNullField >= 0) {
                            int start;
                            if ((start = data[pos--] & 0xFF) >= 128) {
                                int curr;
                                int shift = 7;
                                start &= 0x7F;
                                while ((curr = data[pos--] & 0xFF) >= 128) {
                                    start |= (curr & 0x7F) << shift;
                                    shift += 7;
                                }
                                start |= curr << shift;
                            }
                            this.offsets[field2] = start + begin;
                            this.lengths[lastNonNullField] = start + begin - this.offsets[lastNonNullField];
                        } else {
                            this.offsets[field2] = begin;
                        }
                        lastNonNullField = field2;
                    } else {
                        this.offsets[field2] = Integer.MIN_VALUE;
                    }
                    mask >>= 1;
                }
            }
            if (lastNonNullField >= 0) {
                this.lengths[lastNonNullField] = pos - this.offsets[lastNonNullField] + 1;
            }
            this.firstModifiedPos = Integer.MAX_VALUE;
        }
        catch (ArrayIndexOutOfBoundsException aioobex) {
            StringBuilder bld = new StringBuilder(len * 4 + 64);
            bld.append("Record deserialization error: Record byte signature: ");
            for (int i = 0; i < len; ++i) {
                int num = data[i + begin] & 0xFF;
                bld.append(num);
                if (i >= len - 1) continue;
                bld.append(',');
            }
            throw new RuntimeException(bld.toString(), aioobex);
        }
    }

    public long serialize(DataOutputView target) throws IOException {
        this.updateBinaryRepresenation();
        long bytesForLen = 1L;
        int len = this.binaryLen;
        while (len >= 128) {
            target.write(len | 0x80);
            len >>= 7;
            ++bytesForLen;
        }
        target.write(len);
        target.write(this.binaryData, 0, this.binaryLen);
        return bytesForLen + (long)this.binaryLen;
    }

    public void deserialize(DataInputView source) throws IOException {
        this.read(source);
    }

    private static final void writeVarLengthInt(DataOutput out, int value) throws IOException {
        while (value >= 128) {
            out.write(value | 0x80);
            value >>= 7;
        }
        out.write(value);
    }

    private static final int readVarLengthInt(DataInput in) throws IOException {
        int val = in.readUnsignedByte();
        if (val >= 128) {
            int curr;
            int shift = 7;
            val &= 0x7F;
            while ((curr = in.readUnsignedByte()) >= 128) {
                val |= (curr & 0x7F) << shift;
                shift += 7;
            }
            val |= curr << shift;
        }
        return val;
    }

    private static final class InternalDeSerializer
    implements DataInputView,
    DataOutputView,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] memory;
        private int position;
        private int end;
        private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
        private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

        private InternalDeSerializer() {
        }

        @Override
        public boolean readBoolean() throws IOException {
            if (this.position < this.end) {
                return this.memory[this.position++] != 0;
            }
            throw new EOFException();
        }

        @Override
        public byte readByte() throws IOException {
            if (this.position < this.end) {
                return this.memory[this.position++];
            }
            throw new EOFException();
        }

        @Override
        public char readChar() throws IOException {
            if (this.position < this.end - 1) {
                return (char)((this.memory[this.position++] & 0xFF) << 8 | (this.memory[this.position++] & 0xFF) << 0);
            }
            throw new EOFException();
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            if (len >= 0) {
                if (off > b.length - len) throw new ArrayIndexOutOfBoundsException();
                if (this.position > this.end - len) throw new EOFException();
                System.arraycopy(this.memory, this.position, b, off, len);
                this.position += len;
                return;
            } else {
                if (len >= 0) return;
                throw new IllegalArgumentException("Length may not be negative.");
            }
        }

        @Override
        public int readInt() throws IOException {
            if (this.position >= 0 && this.position < this.end - 3) {
                int value = UNSAFE.getInt(this.memory, BASE_OFFSET + (long)this.position);
                if (LITTLE_ENDIAN) {
                    value = Integer.reverseBytes(value);
                }
                this.position += 4;
                return value;
            }
            throw new EOFException();
        }

        @Override
        public String readLine() throws IOException {
            if (this.position < this.end) {
                StringBuilder bld = new StringBuilder();
                char curr = (char)this.readUnsignedByte();
                while (this.position < this.end && curr != '\n') {
                    bld.append(curr);
                    curr = (char)this.readUnsignedByte();
                }
                int len = bld.length();
                if (len > 0 && bld.charAt(len - 1) == '\r') {
                    bld.setLength(len - 1);
                }
                String s = bld.toString();
                bld.setLength(0);
                return s;
            }
            return null;
        }

        @Override
        public long readLong() throws IOException {
            if (this.position >= 0 && this.position < this.end - 7) {
                long value = UNSAFE.getLong(this.memory, BASE_OFFSET + (long)this.position);
                if (LITTLE_ENDIAN) {
                    value = Long.reverseBytes(value);
                }
                this.position += 8;
                return value;
            }
            throw new EOFException();
        }

        @Override
        public short readShort() throws IOException {
            if (this.position >= 0 && this.position < this.end - 1) {
                return (short)((this.memory[this.position++] & 0xFF) << 8 | (this.memory[this.position++] & 0xFF) << 0);
            }
            throw new EOFException();
        }

        @Override
        public String readUTF() throws IOException {
            int c;
            int count;
            int utflen = this.readUnsignedShort();
            byte[] bytearr = new byte[utflen];
            char[] chararr = new char[utflen];
            int chararr_count = 0;
            this.readFully(bytearr, 0, utflen);
            for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)c;
            }
            block6: while (count < utflen) {
                c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        chararr[chararr_count++] = (char)c;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + count);
                        }
                        chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                        }
                        chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + count);
            }
            return new String(chararr, 0, chararr_count);
        }

        @Override
        public int readUnsignedByte() throws IOException {
            if (this.position < this.end) {
                return this.memory[this.position++] & 0xFF;
            }
            throw new EOFException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (this.position < this.end - 1) {
                return (this.memory[this.position++] & 0xFF) << 8 | (this.memory[this.position++] & 0xFF) << 0;
            }
            throw new EOFException();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            if (this.position <= this.end - n) {
                this.position += n;
                return n;
            }
            n = this.end - this.position;
            this.position = this.end;
            return n;
        }

        @Override
        public void skipBytesToRead(int numBytes) throws IOException {
            if (this.end - this.position < numBytes) {
                throw new EOFException("Could not skip " + numBytes + ".");
            }
            this.skipBytes(numBytes);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException("Byte array b cannot be null.");
            }
            if (off < 0) {
                throw new IndexOutOfBoundsException("Offset cannot be negative.");
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("Length cannot be negative.");
            }
            if (b.length - off < len) {
                throw new IndexOutOfBoundsException("Byte array does not provide enough space to store requested data.");
            }
            if (this.position >= this.end) {
                return -1;
            }
            int toRead = Math.min(this.end - this.position, len);
            System.arraycopy(this.memory, this.position, b, off, toRead);
            this.position += toRead;
            return toRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.position >= this.memory.length) {
                this.resize(1);
            }
            this.memory[this.position++] = (byte)(b & 0xFF);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len < 0 || off > b.length - len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.position > this.memory.length - len) {
                this.resize(len);
            }
            System.arraycopy(b, off, this.memory, this.position, len);
            this.position += len;
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.write(v ? 1 : 0);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.write(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int sLen = s.length();
            if (this.position >= this.memory.length - sLen) {
                this.resize(sLen);
            }
            for (int i = 0; i < sLen; ++i) {
                this.writeByte(s.charAt(i));
            }
            this.position += sLen;
        }

        @Override
        public void writeChar(int v) throws IOException {
            if (this.position >= this.memory.length - 1) {
                this.resize(2);
            }
            this.memory[this.position++] = (byte)(v >> 8);
            this.memory[this.position++] = (byte)v;
        }

        @Override
        public void writeChars(String s) throws IOException {
            int sLen = s.length();
            if (this.position >= this.memory.length - 2 * sLen) {
                this.resize(2 * sLen);
            }
            for (int i = 0; i < sLen; ++i) {
                this.writeChar(s.charAt(i));
            }
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.position >= this.memory.length - 3) {
                this.resize(4);
            }
            if (LITTLE_ENDIAN) {
                v = Integer.reverseBytes(v);
            }
            UNSAFE.putInt(this.memory, BASE_OFFSET + (long)this.position, v);
            this.position += 4;
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (this.position >= this.memory.length - 7) {
                this.resize(8);
            }
            if (LITTLE_ENDIAN) {
                v = Long.reverseBytes(v);
            }
            UNSAFE.putLong(this.memory, BASE_OFFSET + (long)this.position, v);
            this.position += 8;
        }

        @Override
        public void writeShort(int v) throws IOException {
            if (this.position >= this.memory.length - 1) {
                this.resize(2);
            }
            this.memory[this.position++] = (byte)(v >>> 8 & 0xFF);
            this.memory[this.position++] = (byte)(v >>> 0 & 0xFF);
        }

        @Override
        public void writeUTF(String str) throws IOException {
            char c;
            int strlen = str.length();
            int utflen = 0;
            for (int i = 0; i < strlen; ++i) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            if (utflen > 65535) {
                throw new UTFDataFormatException("Encoded string is too long: " + utflen);
            }
            if (this.position > this.memory.length - utflen - 2) {
                this.resize(utflen + 2);
            }
            byte[] bytearr = this.memory;
            int count = this.position;
            bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
            int i = 0;
            for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
                bytearr[count++] = (byte)c;
            }
            while (i < strlen) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                } else if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
            this.position = count;
        }

        private void writeValLenIntBackwards(int value) throws IOException {
            if (this.position > this.memory.length - 4) {
                this.resize(4);
            }
            if (value <= 127) {
                this.memory[this.position++] = (byte)value;
            } else if (value <= 16383) {
                this.memory[this.position++] = (byte)(value >>> 7);
                this.memory[this.position++] = (byte)(value | 0x80);
            } else if (value <= 0x1FFFFF) {
                this.memory[this.position++] = (byte)(value >>> 14);
                this.memory[this.position++] = (byte)(value >>> 7 | 0x80);
                this.memory[this.position++] = (byte)(value | 0x80);
            } else if (value <= 0xFFFFFFF) {
                this.memory[this.position++] = (byte)(value >>> 21);
                this.memory[this.position++] = (byte)(value >>> 14 | 0x80);
                this.memory[this.position++] = (byte)(value >>> 7 | 0x80);
                this.memory[this.position++] = (byte)(value | 0x80);
            } else {
                this.memory[this.position++] = (byte)(value >>> 28);
                this.memory[this.position++] = (byte)(value >>> 21 | 0x80);
                this.memory[this.position++] = (byte)(value >>> 14 | 0x80);
                this.memory[this.position++] = (byte)(value >>> 7 | 0x80);
                this.memory[this.position++] = (byte)(value | 0x80);
            }
        }

        private void resize(int minCapacityAdd) throws IOException {
            try {
                int newLen = Math.max(this.memory.length * 2, this.memory.length + minCapacityAdd);
                byte[] nb = new byte[newLen];
                System.arraycopy(this.memory, 0, nb, 0, this.position);
                this.memory = nb;
            }
            catch (NegativeArraySizeException nasex) {
                throw new IOException("Serialization failed because the record length would exceed 2GB.");
            }
        }

        @Override
        public void skipBytesToWrite(int numBytes) throws IOException {
            int skippedBytes = this.skipBytes(numBytes);
            if (skippedBytes != numBytes) {
                throw new EOFException("Could not skip " + numBytes + " bytes.");
            }
        }

        @Override
        public void write(DataInputView source, int numBytes) throws IOException {
            if (numBytes > this.end - this.position) {
                throw new IOException("Could not write " + numBytes + " bytes since the buffer is full.");
            }
            source.readFully(this.memory, this.position, numBytes);
            this.position += numBytes;
        }

        static /* synthetic */ byte[] access$102(InternalDeSerializer x0, byte[] x1) {
            x0.memory = x1;
            return x1;
        }
    }
}

