/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ClusterStatus {
    private static final byte VERSION = 2;
    private String hbaseVersion;
    private Map<ServerName, ServerLoad> liveServers;
    private Collection<ServerName> deadServers;
    private ServerName master;
    private Collection<ServerName> backupMasters;
    private List<RegionState> intransition;
    private String clusterId;
    private String[] masterCoprocessors;
    private Boolean balancerOn;
    private int masterInfoPort;

    @Deprecated
    public ClusterStatus(String hbaseVersion, String clusterid, Map<ServerName, ServerLoad> servers, Collection<ServerName> deadServers, ServerName master, Collection<ServerName> backupMasters, List<RegionState> rit, String[] masterCoprocessors, Boolean balancerOn, int masterInfoPort) {
        this.hbaseVersion = hbaseVersion;
        this.liveServers = servers;
        this.deadServers = deadServers;
        this.master = master;
        this.backupMasters = backupMasters;
        this.intransition = rit;
        this.clusterId = clusterid;
        this.masterCoprocessors = masterCoprocessors;
        this.balancerOn = balancerOn;
        this.masterInfoPort = masterInfoPort;
    }

    public Collection<ServerName> getDeadServerNames() {
        if (this.deadServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServersSize() {
        return this.liveServers != null ? this.liveServers.size() : 0;
    }

    @Deprecated
    public int getDeadServers() {
        return this.getDeadServersSize();
    }

    public int getDeadServersSize() {
        return this.deadServers != null ? this.deadServers.size() : 0;
    }

    public double getAverageLoad() {
        int load = this.getRegionsCount();
        int serverSize = this.getServersSize();
        return serverSize != 0 ? (double)load / (double)serverSize : 0.0;
    }

    public int getRegionsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count += e.getValue().getNumberOfRegions();
            }
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        if (this.liveServers != null && !this.liveServers.isEmpty()) {
            for (Map.Entry<ServerName, ServerLoad> e : this.liveServers.entrySet()) {
                count = (int)((long)count + e.getValue().getNumberOfRequests());
            }
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        ClusterStatus other = (ClusterStatus)o;
        return Objects.equal((Object)this.getHBaseVersion(), (Object)other.getHBaseVersion()) && Objects.equal(this.liveServers, other.liveServers) && this.getDeadServerNames().containsAll(other.getDeadServerNames()) && Arrays.equals(this.getMasterCoprocessors(), other.getMasterCoprocessors()) && Objects.equal((Object)this.getMaster(), (Object)other.getMaster()) && this.getBackupMasters().containsAll(other.getBackupMasters()) && Objects.equal((Object)this.getClusterId(), (Object)other.getClusterId()) && this.getMasterInfoPort() == other.getMasterInfoPort();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hbaseVersion, this.liveServers, this.deadServers, this.master, this.backupMasters, this.clusterId, this.masterInfoPort});
    }

    @Deprecated
    public byte getVersion() {
        return 2;
    }

    public Collection<ServerName> getServers() {
        if (this.liveServers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.liveServers.keySet());
    }

    public ServerName getMaster() {
        return this.master;
    }

    public int getBackupMastersSize() {
        return this.backupMasters != null ? this.backupMasters.size() : 0;
    }

    public Collection<ServerName> getBackupMasters() {
        if (this.backupMasters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.backupMasters);
    }

    public ServerLoad getLoad(ServerName sn) {
        return this.liveServers != null ? this.liveServers.get(sn) : null;
    }

    @InterfaceAudience.Private
    public List<RegionState> getRegionsInTransition() {
        return this.intransition;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String[] getMasterCoprocessors() {
        return this.masterCoprocessors;
    }

    public long getLastMajorCompactionTsForTable(TableName table) {
        long result = Long.MAX_VALUE;
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            for (RegionLoad rl : load.getRegionsLoad().values()) {
                if (!table.equals(HRegionInfo.getTable(rl.getName()))) continue;
                result = Math.min(result, rl.getLastMajorCompactionTs());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    public long getLastMajorCompactionTsForRegion(byte[] region) {
        for (ServerName server : this.getServers()) {
            ServerLoad load = this.getLoad(server);
            RegionLoad rl = load.getRegionsLoad().get(region);
            if (rl == null) continue;
            return rl.getLastMajorCompactionTs();
        }
        return 0L;
    }

    public boolean isBalancerOn() {
        return this.balancerOn != null && this.balancerOn != false;
    }

    public Boolean getBalancerOn() {
        return this.balancerOn;
    }

    public int getMasterInfoPort() {
        return this.masterInfoPort;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("Master: " + this.master);
        int backupMastersSize = this.getBackupMastersSize();
        sb.append("\nNumber of backup masters: " + backupMastersSize);
        if (backupMastersSize > 0) {
            for (ServerName serverName : this.backupMasters) {
                sb.append("\n  " + serverName);
            }
        }
        int serversSize = this.getServersSize();
        sb.append("\nNumber of live region servers: " + serversSize);
        if (serversSize > 0) {
            for (ServerName serverName : this.liveServers.keySet()) {
                sb.append("\n  " + serverName.getServerName());
            }
        }
        int n = this.getDeadServersSize();
        sb.append("\nNumber of dead region servers: " + n);
        if (n > 0) {
            for (ServerName serverName : this.deadServers) {
                sb.append("\n  " + serverName);
            }
        }
        sb.append("\nAverage load: " + this.getAverageLoad());
        sb.append("\nNumber of requests: " + this.getRequestsCount());
        sb.append("\nNumber of regions: " + this.getRegionsCount());
        int n2 = this.intransition != null ? this.intransition.size() : 0;
        sb.append("\nNumber of regions in transition: " + n2);
        if (n2 > 0) {
            for (RegionState state : this.intransition) {
                sb.append("\n  " + state.toDescriptiveString());
            }
        }
        return sb.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum Option {
        HBASE_VERSION,
        CLUSTER_ID,
        BALANCER_ON,
        LIVE_SERVERS,
        DEAD_SERVERS,
        MASTER,
        BACKUP_MASTERS,
        MASTER_COPROCESSORS,
        REGIONS_IN_TRANSITION,
        MASTER_INFO_PORT;

    }

    @InterfaceAudience.Private
    public static class Builder {
        private String hbaseVersion = null;
        private Map<ServerName, ServerLoad> liveServers = null;
        private Collection<ServerName> deadServers = null;
        private ServerName master = null;
        private Collection<ServerName> backupMasters = null;
        private List<RegionState> intransition = null;
        private String clusterId = null;
        private String[] masterCoprocessors = null;
        private Boolean balancerOn = null;
        private int masterInfoPort = -1;

        private Builder() {
        }

        public Builder setHBaseVersion(String hbaseVersion) {
            this.hbaseVersion = hbaseVersion;
            return this;
        }

        public Builder setLiveServers(Map<ServerName, ServerLoad> liveServers) {
            this.liveServers = liveServers;
            return this;
        }

        public Builder setDeadServers(Collection<ServerName> deadServers) {
            this.deadServers = deadServers;
            return this;
        }

        public Builder setMaster(ServerName master) {
            this.master = master;
            return this;
        }

        public Builder setBackupMasters(Collection<ServerName> backupMasters) {
            this.backupMasters = backupMasters;
            return this;
        }

        public Builder setRegionState(List<RegionState> intransition) {
            this.intransition = intransition;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setMasterCoprocessors(String[] masterCoprocessors) {
            this.masterCoprocessors = masterCoprocessors;
            return this;
        }

        public Builder setBalancerOn(Boolean balancerOn) {
            this.balancerOn = balancerOn;
            return this;
        }

        public Builder setMasterInfoPort(int masterInfoPort) {
            this.masterInfoPort = masterInfoPort;
            return this;
        }

        public ClusterStatus build() {
            return new ClusterStatus(this.hbaseVersion, this.clusterId, this.liveServers, this.deadServers, this.master, this.backupMasters, this.intransition, this.masterCoprocessors, this.balancerOn, this.masterInfoPort);
        }
    }
}

