/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncRegionLocator {
    private static final Log LOG = LogFactory.getLog(AsyncRegionLocator.class);
    private final HashedWheelTimer retryTimer;
    private final AsyncMetaRegionLocator metaRegionLocator;
    private final AsyncNonMetaRegionLocator nonMetaRegionLocator;

    AsyncRegionLocator(AsyncConnectionImpl conn, HashedWheelTimer retryTimer) {
        this.metaRegionLocator = new AsyncMetaRegionLocator(conn.registry);
        this.nonMetaRegionLocator = new AsyncNonMetaRegionLocator(conn);
        this.retryTimer = retryTimer;
    }

    private CompletableFuture<HRegionLocation> withTimeout(CompletableFuture<HRegionLocation> future, long timeoutNs, Supplier<String> timeoutMsg) {
        if (future.isDone() || timeoutNs <= 0L) {
            return future;
        }
        Timeout timeoutTask = this.retryTimer.newTimeout(t -> {
            if (future.isDone()) {
                return;
            }
            future.completeExceptionally(new TimeoutIOException((String)timeoutMsg.get()));
        }, timeoutNs, TimeUnit.NANOSECONDS);
        return future.whenComplete((loc, error) -> {
            if (error != null && error.getClass() != TimeoutIOException.class) {
                timeoutTask.cancel();
            }
        });
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, RegionLocateType type, boolean reload, long timeoutNs) {
        CompletableFuture<HRegionLocation> future = tableName.equals(TableName.META_TABLE_NAME) ? this.metaRegionLocator.getRegionLocation(reload) : this.nonMetaRegionLocator.getRegionLocation(tableName, row, type, reload);
        return this.withTimeout(future, timeoutNs, () -> "Timeout(" + TimeUnit.NANOSECONDS.toMillis(timeoutNs) + "ms) waiting for region location for " + tableName + ", row='" + Bytes.toStringBinary(row) + "'");
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, RegionLocateType type, long timeoutNs) {
        return this.getRegionLocation(tableName, row, type, false, timeoutNs);
    }

    static boolean canUpdate(HRegionLocation loc, HRegionLocation oldLoc) {
        return oldLoc != null && oldLoc.getSeqNum() <= loc.getSeqNum() && oldLoc.getServerName().equals((Object)loc.getServerName());
    }

    static void updateCachedLocation(HRegionLocation loc, Throwable exception, Function<HRegionLocation, HRegionLocation> cachedLocationSupplier, Consumer<HRegionLocation> addToCache, Consumer<HRegionLocation> removeFromCache) {
        HRegionLocation oldLoc = cachedLocationSupplier.apply(loc);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Try updating " + loc + ", the old value is " + oldLoc), exception);
        }
        if (!AsyncRegionLocator.canUpdate(loc, oldLoc)) {
            return;
        }
        Throwable cause = ClientExceptionsUtil.findException(exception);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The actual exception when updating " + loc), cause);
        }
        if (cause == null || !ClientExceptionsUtil.isMetaClearingException(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Will not update " + loc + " because the exception is null or not the one we care about"));
            }
            return;
        }
        if (cause instanceof RegionMovedException) {
            RegionMovedException rme = (RegionMovedException)cause;
            HRegionLocation newLoc = new HRegionLocation(loc.getRegionInfo(), rme.getServerName(), rme.getLocationSeqNum());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Try updating " + loc + " with the new location " + newLoc + " constructed by " + rme));
            }
            addToCache.accept(newLoc);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Try removing " + loc + " from cache"));
            }
            removeFromCache.accept(loc);
        }
    }

    void updateCachedLocation(HRegionLocation loc, Throwable exception) {
        if (loc.getRegion().isMetaRegion()) {
            this.metaRegionLocator.updateCachedLocation(loc, exception);
        } else {
            this.nonMetaRegionLocator.updateCachedLocation(loc, exception);
        }
    }

    void clearCache(TableName tableName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clear meta cache for " + tableName));
        }
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            this.metaRegionLocator.clearCache();
        } else {
            this.nonMetaRegionLocator.clearCache(tableName);
        }
    }
}

