/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BinaryPrefixComparator
extends ByteArrayComparable {
    public BinaryPrefixComparator(byte[] value) {
        super(value);
    }

    public int compareTo(byte[] value, int offset, int length) {
        return Bytes.compareTo(this.value, 0, this.value.length, value, offset, this.value.length <= length ? this.value.length : length);
    }

    public int compareTo(ByteBuffer value, int offset, int length) {
        if (this.value.length <= length) {
            length = this.value.length;
        }
        return ByteBufferUtils.compareTo((byte[])this.value, (int)0, (int)this.value.length, (ByteBuffer)value, (int)offset, (int)length);
    }

    public byte[] toByteArray() {
        ComparatorProtos.BinaryPrefixComparator.Builder builder = ComparatorProtos.BinaryPrefixComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static BinaryPrefixComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BinaryPrefixComparator proto;
        try {
            proto = ComparatorProtos.BinaryPrefixComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new BinaryPrefixComparator(proto.getComparable().getValue().toByteArray());
    }

    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryPrefixComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

