/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.FileCleanerDelegate;
import org.apache.hadoop.hbase.util.FSUtils;

public abstract class CleanerChore<T extends FileCleanerDelegate>
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog((String)CleanerChore.class.getName());
    private final FileSystem fs;
    private final Path oldFileDir;
    private final Configuration conf;
    protected List<T> cleanersChain;

    public CleanerChore(String name, int sleepPeriod, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confKey) {
        super(name, s, sleepPeriod);
        this.fs = fs;
        this.oldFileDir = oldFileDir;
        this.conf = conf;
        this.initCleanerChain(confKey);
    }

    protected abstract boolean validate(Path var1);

    private void initCleanerChain(String confKey) {
        this.cleanersChain = new LinkedList<T>();
        String[] logCleaners = this.conf.getStrings(confKey);
        if (logCleaners != null) {
            for (String className : logCleaners) {
                T logCleaner = this.newFileCleaner(className, this.conf);
                if (logCleaner == null) continue;
                LOG.debug((Object)("initialize cleaner=" + className));
                this.cleanersChain.add(logCleaner);
            }
        }
    }

    private T newFileCleaner(String className, Configuration conf) {
        try {
            Class<FileCleanerDelegate> c = Class.forName(className).asSubclass(FileCleanerDelegate.class);
            FileCleanerDelegate cleaner = c.newInstance();
            cleaner.setConf(conf);
            return (T)cleaner;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can NOT create CleanerDelegate: " + className), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void chore() {
        try {
            FileStatus[] files = FSUtils.listStatus(this.fs, this.oldFileDir);
            this.checkAndDeleteEntries(files);
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException((IOException)e);
            LOG.warn((Object)"Error while cleaning the logs", (Throwable)e);
        }
    }

    private boolean checkAndDeleteEntries(FileStatus[] entries) {
        if (entries == null) {
            return true;
        }
        boolean allEntriesDeleted = true;
        ArrayList files = Lists.newArrayListWithCapacity((int)entries.length);
        for (FileStatus child : entries) {
            Path path = child.getPath();
            if (child.isDirectory()) {
                if (this.checkAndDeleteDirectory(path)) continue;
                allEntriesDeleted = false;
                continue;
            }
            files.add(child);
        }
        if (!this.checkAndDeleteFiles(files)) {
            allEntriesDeleted = false;
        }
        return allEntriesDeleted;
    }

    @VisibleForTesting
    boolean checkAndDeleteDirectory(Path dir) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Checking directory: " + dir));
        }
        try {
            FileStatus[] children = FSUtils.listStatus(this.fs, dir);
            boolean allChildrenDeleted = this.checkAndDeleteEntries(children);
            if (!allChildrenDeleted) {
                return false;
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException((IOException)e);
            LOG.warn((Object)("Error while listing directory: " + dir), (Throwable)e);
            return false;
        }
        try {
            return this.fs.delete(dir, false);
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Couldn't delete directory: " + dir), (Throwable)e);
            }
            return false;
        }
    }

    private boolean checkAndDeleteFiles(List<FileStatus> files) {
        ArrayList validFiles = Lists.newArrayListWithCapacity((int)files.size());
        ArrayList invalidFiles = Lists.newArrayList();
        for (FileStatus file : files) {
            if (this.validate(file.getPath())) {
                validFiles.add(file);
                continue;
            }
            LOG.warn((Object)("Found a wrongly formatted file: " + file.getPath() + " - will delete it."));
            invalidFiles.add(file);
        }
        Iterable<Object> deletableValidFiles = validFiles;
        for (FileCleanerDelegate cleaner : this.cleanersChain) {
            if (cleaner.isStopped() || this.getStopper().isStopped()) {
                LOG.warn((Object)("A file cleaner" + this.getName() + " is stopped, won't delete any more files in:" + this.oldFileDir));
                return false;
            }
            Iterable<FileStatus> filteredFiles = cleaner.getDeletableFiles((Iterable<FileStatus>)deletableValidFiles);
            if (LOG.isTraceEnabled()) {
                ImmutableSet filteredFileSet = ImmutableSet.copyOf(filteredFiles);
                for (FileStatus fileStatus : deletableValidFiles) {
                    if (filteredFileSet.contains((Object)fileStatus)) continue;
                    LOG.trace((Object)(fileStatus.getPath() + " is not deletable according to:" + cleaner));
                }
            }
            deletableValidFiles = filteredFiles;
        }
        Iterable filesToDelete = Iterables.concat((Iterable)invalidFiles, (Iterable)deletableValidFiles);
        int deletedFileCount = 0;
        for (FileStatus file : filesToDelete) {
            Path filePath = file.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing: " + filePath + " from archive"));
            }
            try {
                boolean bl = this.fs.delete(filePath, false);
                if (bl) {
                    ++deletedFileCount;
                    continue;
                }
                LOG.warn((Object)("Attempted to delete:" + filePath + ", but couldn't. Run cleaner chain and attempt to delete on next pass."));
            }
            catch (IOException iOException) {
                IOException iOException2 = RemoteExceptionHandler.checkIOException((IOException)iOException);
                LOG.warn((Object)("Error while deleting: " + filePath), (Throwable)iOException2);
            }
        }
        return deletedFileCount == files.size();
    }

    @Override
    public void cleanup() {
        for (FileCleanerDelegate lc : this.cleanersChain) {
            try {
                lc.stop("Exiting");
            }
            catch (Throwable t) {
                LOG.warn((Object)"Stopping", t);
            }
        }
    }
}

