/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.com.google.gson.JsonArray;
import org.apache.hadoop.hbase.shaded.com.google.gson.JsonElement;
import org.apache.hadoop.hbase.shaded.com.google.gson.JsonObject;
import org.apache.hadoop.hbase.shaded.com.google.gson.JsonParser;
import org.apache.hadoop.hbase.shaded.com.google.gson.JsonPrimitive;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.BytesValue;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.util.JsonFormat;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProtobufMessageConverter {
    private static final String TYPE_KEY = "@type";
    private static final JsonFormat.Printer jsonPrinter;

    private ProtobufMessageConverter() {
    }

    public static String toJsonString(MessageOrBuilder messageOrBuilder) throws InvalidProtocolBufferException {
        return jsonPrinter.print(messageOrBuilder);
    }

    private static void removeTypeFromJson(JsonElement json2) {
        block4: {
            block3: {
                if (!json2.isJsonArray()) break block3;
                for (JsonElement child : json2.getAsJsonArray()) {
                    ProtobufMessageConverter.removeTypeFromJson(child);
                }
                break block4;
            }
            if (!json2.isJsonObject()) break block4;
            Iterator iterator2 = json2.getAsJsonObject().entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                if (TYPE_KEY.equals(entry.getKey())) {
                    iterator2.remove();
                    continue;
                }
                ProtobufMessageConverter.removeTypeFromJson((JsonElement)entry.getValue());
            }
        }
    }

    public static JsonElement toJsonElement(MessageOrBuilder messageOrBuilder) throws InvalidProtocolBufferException {
        return ProtobufMessageConverter.toJsonElement(messageOrBuilder, true);
    }

    public static JsonElement toJsonElement(MessageOrBuilder messageOrBuilder, boolean removeType) throws InvalidProtocolBufferException {
        String jsonString = ProtobufMessageConverter.toJsonString(messageOrBuilder);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(jsonString);
        if (removeType) {
            ProtobufMessageConverter.removeTypeFromJson(element);
        }
        return element;
    }

    private static Object toJavaObject(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            return null;
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement arrayElement : array) {
                Object javaObject = ProtobufMessageConverter.toJavaObject(arrayElement);
                list.add(javaObject);
            }
            return list;
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry entry : object.entrySet()) {
                Object javaObject = ProtobufMessageConverter.toJavaObject((JsonElement)entry.getValue());
                map.put(entry.getKey(), javaObject);
            }
            return map;
        }
        return null;
    }

    public static Object toJavaObject(MessageOrBuilder messageOrBuilder) throws InvalidProtocolBufferException {
        JsonElement element = ProtobufMessageConverter.toJsonElement(messageOrBuilder);
        return ProtobufMessageConverter.toJavaObject(element);
    }

    static {
        JsonFormat.TypeRegistry.Builder builder = JsonFormat.TypeRegistry.newBuilder();
        builder.add(BytesValue.getDescriptor()).add((Iterable)LockServiceProtos.getDescriptor().getMessageTypes()).add((Iterable)MasterProcedureProtos.getDescriptor().getMessageTypes()).add((Iterable)ProcedureProtos.getDescriptor().getMessageTypes());
        JsonFormat.TypeRegistry typeRegistry = builder.build();
        jsonPrinter = JsonFormat.printer().usingTypeRegistry(typeRegistry).omittingInsignificantWhitespace();
    }
}

