/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.beust.jcommander;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hudi.com.beust.jcommander.DynamicParameter;
import org.apache.hudi.com.beust.jcommander.IParameterValidator;
import org.apache.hudi.com.beust.jcommander.IParameterValidator2;
import org.apache.hudi.com.beust.jcommander.IValueValidator;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.com.beust.jcommander.Parameterized;
import org.apache.hudi.com.beust.jcommander.Parameters;
import org.apache.hudi.com.beust.jcommander.ResourceBundle;
import org.apache.hudi.com.beust.jcommander.SubParameter;
import org.apache.hudi.com.beust.jcommander.WrappedParameter;
import org.apache.hudi.com.beust.jcommander.validators.NoValidator;
import org.apache.hudi.com.beust.jcommander.validators.NoValueValidator;

public class ParameterDescription {
    private Object object;
    private WrappedParameter wrappedParameter;
    private Parameter parameterAnnotation;
    private DynamicParameter dynamicParameterAnnotation;
    private Parameterized parameterized;
    private boolean assigned = false;
    private java.util.ResourceBundle bundle;
    private String description;
    private JCommander jCommander;
    private Object defaultObject;
    private String longestName = "";

    public ParameterDescription(Object object, DynamicParameter dynamicParameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        if (!Map.class.isAssignableFrom(parameterized.getType())) {
            throw new ParameterException("@DynamicParameter " + parameterized.getName() + " should be of type Map but is " + parameterized.getType().getName());
        }
        this.dynamicParameterAnnotation = dynamicParameter;
        this.wrappedParameter = new WrappedParameter(this.dynamicParameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    public ParameterDescription(Object object, Parameter parameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.parameterAnnotation = parameter;
        this.wrappedParameter = new WrappedParameter(this.parameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    private java.util.ResourceBundle findResourceBundle(Object object) {
        java.util.ResourceBundle resourceBundle = null;
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        if (parameters != null && !this.isEmpty(parameters.resourceBundle())) {
            resourceBundle = java.util.ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle resourceBundle2 = object.getClass().getAnnotation(ResourceBundle.class);
            if (resourceBundle2 != null && !this.isEmpty(resourceBundle2.value())) {
                resourceBundle = java.util.ResourceBundle.getBundle(resourceBundle2.value(), Locale.getDefault());
            }
        }
        return resourceBundle;
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private void initDescription(String string, String string2, String[] stringArray) {
        this.description = string;
        if (!"".equals(string2) && this.bundle != null) {
            this.description = this.bundle.getString(string2);
        }
        for (String string3 : stringArray) {
            if (string3.length() <= this.longestName.length()) continue;
            this.longestName = string3;
        }
    }

    private void init(Object object, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.object = object;
        this.parameterized = parameterized;
        this.bundle = resourceBundle;
        if (this.bundle == null) {
            this.bundle = this.findResourceBundle(object);
        }
        this.jCommander = jCommander;
        if (this.parameterAnnotation != null) {
            String string = Enum.class.isAssignableFrom(parameterized.getType()) && this.parameterAnnotation.description().isEmpty() ? "Options: " + EnumSet.allOf(parameterized.getType()) : this.parameterAnnotation.description();
            this.initDescription(string, this.parameterAnnotation.descriptionKey(), this.parameterAnnotation.names());
        } else if (this.dynamicParameterAnnotation != null) {
            this.initDescription(this.dynamicParameterAnnotation.description(), this.dynamicParameterAnnotation.descriptionKey(), this.dynamicParameterAnnotation.names());
        } else {
            throw new AssertionError((Object)"Shound never happen");
        }
        try {
            this.defaultObject = parameterized.get(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.defaultObject != null && this.parameterAnnotation != null) {
            this.validateDefaultValues(this.parameterAnnotation.names());
        }
    }

    private void validateDefaultValues(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "";
        this.validateValueParameter(string, this.defaultObject);
    }

    public String getLongestName() {
        return this.longestName;
    }

    public Object getDefault() {
        return this.defaultObject;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getObject() {
        return this.object;
    }

    public String getNames() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.wrappedParameter.names();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public WrappedParameter getParameter() {
        return this.wrappedParameter;
    }

    public Parameterized getParameterized() {
        return this.parameterized;
    }

    private boolean isMultiOption() {
        Class<?> clazz = this.parameterized.getType();
        return clazz.equals(List.class) || clazz.equals(Set.class) || this.parameterized.isDynamicParameter();
    }

    public void addValue(String string) {
        this.addValue(string, false);
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void setAssigned(boolean bl) {
        this.assigned = bl;
    }

    public void addValue(String string, boolean bl) {
        this.addValue(null, string, bl, true, -1);
    }

    Object addValue(String string, String string2, boolean bl, boolean bl2, int n) {
        Collection<Object> collection;
        boolean bl3;
        ParameterDescription.p("Adding " + (bl ? "default " : "") + "value:" + string2 + " to parameter:" + this.parameterized.getName());
        if (string == null) {
            string = this.wrappedParameter.names()[0];
        }
        if (n == 0 && this.assigned && !this.isMultiOption() && !this.jCommander.isParameterOverwritingAllowed() || this.isNonOverwritableForced()) {
            throw new ParameterException("Can only specify option " + string + " once.");
        }
        if (bl2) {
            this.validateParameter(string, string2);
        }
        Class<?> clazz = this.parameterized.getType();
        Object object = this.jCommander.convertValue(this.getParameterized(), this.getParameterized().getType(), string, string2);
        if (bl2) {
            this.validateValueParameter(string, object);
        }
        if (bl3 = Collection.class.isAssignableFrom(clazz)) {
            Collection<Object> collection2 = (Collection<Object>)this.parameterized.get(this.object);
            if (collection2 == null || this.fieldIsSetForTheFirstTime(bl)) {
                collection2 = this.newCollection(clazz);
                this.parameterized.set(this.object, collection2);
            }
            if (object instanceof Collection) {
                collection2.addAll((Collection)object);
            } else {
                collection2.add(object);
            }
            collection = collection2;
        } else {
            List<SubParameterIndex> list = this.findSubParameters(clazz);
            if (!list.isEmpty()) {
                collection = this.handleSubParameters(string2, n, clazz, list);
            } else {
                this.wrappedParameter.addValue(this.parameterized, this.object, object);
                collection = object;
            }
        }
        if (!bl) {
            this.assigned = true;
        }
        return collection;
    }

    private Object handleSubParameters(String string, int n, Class<?> clazz, List<SubParameterIndex> list) {
        Object object;
        SubParameterIndex subParameterIndex = null;
        for (SubParameterIndex subParameterIndex2 : list) {
            if (subParameterIndex2.order != n) continue;
            subParameterIndex = subParameterIndex2;
            break;
        }
        if (subParameterIndex != null) {
            Object object2 = this.parameterized.get(this.object);
            try {
                if (object2 == null) {
                    object2 = clazz.newInstance();
                    this.parameterized.set(this.object, object2);
                }
                this.wrappedParameter.addValue(this.parameterized, object2, string, subParameterIndex.field);
                object = object2;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new ParameterException("Couldn't instantiate " + clazz, reflectiveOperationException);
            }
        } else {
            throw new ParameterException("Couldn't find where to assign parameter " + string + " in " + clazz);
        }
        return object;
    }

    public Parameter getParameterAnnotation() {
        return this.parameterAnnotation;
    }

    private List<SubParameterIndex> findSubParameters(Class<?> clazz) {
        ArrayList<SubParameterIndex> arrayList = new ArrayList<SubParameterIndex>();
        for (Field field2 : clazz.getDeclaredFields()) {
            SubParameter subParameter = field2.getAnnotation(SubParameter.class);
            if (subParameter == null) continue;
            SubParameter subParameter2 = subParameter;
            arrayList.add(new SubParameterIndex(subParameter2.order(), field2));
        }
        return arrayList;
    }

    private void validateParameter(String string, String string2) {
        Class<? extends IParameterValidator>[] classArray = this.wrappedParameter.validateWith();
        if (classArray != null && classArray.length > 0) {
            for (Class<? extends IParameterValidator> clazz : classArray) {
                ParameterDescription.validateParameter(this, clazz, string, string2);
            }
        }
    }

    void validateValueParameter(String string, Object object) {
        Class<? extends IValueValidator>[] classArray = this.wrappedParameter.validateValueWith();
        if (classArray != null && classArray.length > 0) {
            for (Class<? extends IValueValidator> clazz : classArray) {
                ParameterDescription.validateValueParameter(clazz, string, object);
            }
        }
    }

    public static void validateValueParameter(Class<? extends IValueValidator> clazz, String string, Object object) {
        try {
            if (clazz != NoValueValidator.class) {
                ParameterDescription.p("Validating value parameter:" + string + " value:" + object + " validator:" + clazz);
            }
            clazz.newInstance().validate(string, object);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ParameterException("Can't instantiate validator:" + reflectiveOperationException);
        }
    }

    public static void validateParameter(ParameterDescription parameterDescription, Class<? extends IParameterValidator> clazz, String string, String string2) {
        try {
            if (clazz != NoValidator.class) {
                ParameterDescription.p("Validating parameter:" + string + " value:" + string2 + " validator:" + clazz);
            }
            clazz.newInstance().validate(string, string2);
            if (IParameterValidator2.class.isAssignableFrom(clazz)) {
                IParameterValidator2 iParameterValidator2 = (IParameterValidator2)clazz.newInstance();
                iParameterValidator2.validate(string, string2, parameterDescription);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ParameterException("Can't instantiate validator:" + reflectiveOperationException);
        }
        catch (ParameterException parameterException) {
            throw parameterException;
        }
        catch (Exception exception) {
            throw new ParameterException(exception);
        }
    }

    private Collection<Object> newCollection(Class<?> clazz) {
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return new TreeSet<Object>();
        }
        if (LinkedHashSet.class.isAssignableFrom(clazz)) {
            return new LinkedHashSet<Object>();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList<Object>();
        }
        throw new ParameterException("Parameters of Collection type '" + clazz.getSimpleName() + "' are not supported. Please use List or Set instead.");
    }

    private boolean fieldIsSetForTheFirstTime(boolean bl) {
        return !bl && !this.assigned;
    }

    private static void p(String string) {
        if (System.getProperty("jcommander.debug") != null) {
            JCommander.getConsole().println("[ParameterDescription] " + string);
        }
    }

    public String toString() {
        return "[ParameterDescription " + this.parameterized.getName() + "]";
    }

    public boolean isDynamicParameter() {
        return this.dynamicParameterAnnotation != null;
    }

    public boolean isHelp() {
        return this.wrappedParameter.isHelp();
    }

    public boolean isNonOverwritableForced() {
        return this.wrappedParameter.isNonOverwritableForced();
    }

    class SubParameterIndex {
        int order = -1;
        Field field;

        public SubParameterIndex(int n, Field field2) {
            this.order = n;
            this.field = field2;
        }
    }
}

