/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.beust.jcommander;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hudi.com.beust.jcommander.DynamicParameter;
import org.apache.hudi.com.beust.jcommander.IParameterValidator;
import org.apache.hudi.com.beust.jcommander.IValueValidator;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.com.beust.jcommander.Parameterized;

public class WrappedParameter {
    private Parameter parameter;
    private DynamicParameter dynamicParameter;

    public WrappedParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public WrappedParameter(DynamicParameter dynamicParameter) {
        this.dynamicParameter = dynamicParameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public DynamicParameter getDynamicParameter() {
        return this.dynamicParameter;
    }

    public int arity() {
        return this.parameter != null ? this.parameter.arity() : 1;
    }

    public boolean hidden() {
        return this.parameter != null ? this.parameter.hidden() : this.dynamicParameter.hidden();
    }

    public boolean required() {
        return this.parameter != null ? this.parameter.required() : this.dynamicParameter.required();
    }

    public boolean password() {
        return this.parameter != null ? this.parameter.password() : false;
    }

    public String[] names() {
        return this.parameter != null ? this.parameter.names() : this.dynamicParameter.names();
    }

    public boolean variableArity() {
        return this.parameter != null ? this.parameter.variableArity() : false;
    }

    public Class<? extends IParameterValidator>[] validateWith() {
        return this.parameter != null ? this.parameter.validateWith() : this.dynamicParameter.validateWith();
    }

    public Class<? extends IValueValidator>[] validateValueWith() {
        return this.parameter != null ? this.parameter.validateValueWith() : this.dynamicParameter.validateValueWith();
    }

    public boolean echoInput() {
        return this.parameter != null ? this.parameter.echoInput() : false;
    }

    public void addValue(Parameterized parameterized, Object object, Object object2) {
        try {
            this.addValue(parameterized, object, object2, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParameterException("Couldn't set " + object + " to " + object2, illegalAccessException);
        }
    }

    public void addValue(Parameterized parameterized, Object object, Object object2, Field field2) throws IllegalAccessException {
        if (this.parameter != null) {
            if (field2 != null) {
                field2.set(object, object2);
            } else {
                parameterized.set(object, object2);
            }
        } else {
            String string = this.dynamicParameter.assignment();
            String string2 = object2.toString();
            int n = string2.indexOf(string);
            if (n == -1) {
                throw new ParameterException("Dynamic parameter expected a value of the form a" + string + "b but got:" + string2);
            }
            this.callPut(object, parameterized, string2.substring(0, n), string2.substring(n + 1));
        }
    }

    private void callPut(Object object, Parameterized parameterized, String string, String string2) {
        try {
            Method method = this.findPut(parameterized.getType());
            method.invoke(parameterized.get(object), string, string2);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    private Method findPut(Class<?> clazz) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod("put", Object.class, Object.class);
    }

    public String getAssignment() {
        return this.dynamicParameter != null ? this.dynamicParameter.assignment() : "";
    }

    public boolean isHelp() {
        return this.parameter != null && this.parameter.help();
    }

    public boolean isNonOverwritableForced() {
        return this.parameter != null && this.parameter.forceNonOverwritable();
    }
}

