/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.client;

import org.apache.hudi.org.eclipse.jetty.client.ContentDecoder;
import org.apache.hudi.org.eclipse.jetty.io.ByteBufferPool;

public class GZIPContentDecoder
extends org.apache.hudi.org.eclipse.jetty.http.GZIPContentDecoder
implements ContentDecoder {
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public GZIPContentDecoder() {
        this(2048);
    }

    public GZIPContentDecoder(int bufferSize) {
        this(null, bufferSize);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int bufferSize) {
        super(byteBufferPool, bufferSize);
    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;
        private final ByteBufferPool byteBufferPool;

        public Factory() {
            this(2048);
        }

        public Factory(int bufferSize) {
            this(null, bufferSize);
        }

        public Factory(ByteBufferPool byteBufferPool) {
            this(byteBufferPool, 2048);
        }

        public Factory(ByteBufferPool byteBufferPool, int bufferSize) {
            super("gzip");
            this.byteBufferPool = byteBufferPool;
            this.bufferSize = bufferSize;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.byteBufferPool, this.bufferSize);
        }
    }
}

