/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

final class FieldSerializerAnnotationsUtil {
    public FieldSerializerAnnotationsUtil(FieldSerializer serializer) {
    }

    public void processAnnotatedFields(FieldSerializer fieldSerializer) {
        FieldSerializer.CachedField[] fields = fieldSerializer.getFields();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation;
            Field field2 = fields[i].getField();
            if (field2.isAnnotationPresent(FieldSerializer.Bind.class)) {
                Class<? extends Serializer> serializerClass = field2.getAnnotation(FieldSerializer.Bind.class).value();
                Serializer s = ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), serializerClass, field2.getClass());
                fields[i].setSerializer(s);
            }
            if (!field2.isAnnotationPresent(CollectionSerializer.BindCollection.class) || field2.isAnnotationPresent(MapSerializer.BindMap.class)) {
                // empty if block
            }
            if (field2.isAnnotationPresent(CollectionSerializer.BindCollection.class)) {
                if (fields[i].serializer != null) {
                    throw new RuntimeException("CollectionSerialier.Bind cannot be used with field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + ", because it has a serializer already.");
                }
                annotation = field2.getAnnotation(CollectionSerializer.BindCollection.class);
                if (Collection.class.isAssignableFrom(fields[i].field.getType())) {
                    Class<? extends Serializer> elementSerializerClass = annotation.elementSerializer();
                    if (elementSerializerClass == Serializer.class) {
                        elementSerializerClass = null;
                    }
                    Serializer elementSerializer = elementSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), elementSerializerClass, field2.getClass());
                    boolean elementsCanBeNull = annotation.elementsCanBeNull();
                    Class<?> elementClass = annotation.elementClass();
                    if (elementClass == Object.class) {
                        elementClass = null;
                    }
                    CollectionSerializer serializer = new CollectionSerializer();
                    serializer.setElementsCanBeNull(elementsCanBeNull);
                    serializer.setElementClass(elementClass, elementSerializer);
                    fields[i].setSerializer(serializer);
                } else {
                    throw new RuntimeException("CollectionSerialier.Bind should be used only with fields implementing java.util.Collection, but field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + " does not implement it.");
                }
            }
            if (!field2.isAnnotationPresent(MapSerializer.BindMap.class)) continue;
            if (fields[i].serializer != null) {
                throw new RuntimeException("MapSerialier.Bind cannot be used with field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + ", because it has a serializer already.");
            }
            annotation = field2.getAnnotation(MapSerializer.BindMap.class);
            if (Map.class.isAssignableFrom(fields[i].field.getType())) {
                Class<? extends Serializer> valueSerializerClass = annotation.valueSerializer();
                Class<? extends Serializer> keySerializerClass = annotation.keySerializer();
                if (valueSerializerClass == Serializer.class) {
                    valueSerializerClass = null;
                }
                if (keySerializerClass == Serializer.class) {
                    keySerializerClass = null;
                }
                Serializer valueSerializer = valueSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), valueSerializerClass, field2.getClass());
                Serializer keySerializer = keySerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), keySerializerClass, field2.getClass());
                boolean valuesCanBeNull = annotation.valuesCanBeNull();
                boolean keysCanBeNull = annotation.keysCanBeNull();
                Class<?> keyClass = annotation.keyClass();
                Class<?> valueClass = annotation.valueClass();
                if (keyClass == Object.class) {
                    keyClass = null;
                }
                if (valueClass == Object.class) {
                    valueClass = null;
                }
                MapSerializer serializer = new MapSerializer();
                serializer.setKeysCanBeNull(keysCanBeNull);
                serializer.setValuesCanBeNull(valuesCanBeNull);
                serializer.setKeyClass(keyClass, keySerializer);
                serializer.setValueClass(valueClass, valueSerializer);
                fields[i].setSerializer(serializer);
                continue;
            }
            throw new RuntimeException("MapSerialier.Bind should be used only with fields implementing java.util.Map, but field " + fields[i].getField().getDeclaringClass().getName() + "." + fields[i].getField().getName() + " does not implement it.");
        }
    }
}

