/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.ObjectMap;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.util.InstantiationUtil;

public class JavaSerializer<T>
extends Serializer<T> {
    @Override
    public void write(Kryo kryo, Output output, T o) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectOutputStream objectStream = (ObjectOutputStream)graphContext.get(this);
            if (objectStream == null) {
                objectStream = new ObjectOutputStream(output);
                graphContext.put(this, objectStream);
            }
            objectStream.writeObject(o);
            objectStream.flush();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java serialization.", ex);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class aClass) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectInputStream objectStream = (ObjectInputStream)graphContext.get(this);
            if (objectStream == null) {
                objectStream = new InstantiationUtil.ClassLoaderObjectInputStream(input, kryo.getClassLoader());
                graphContext.put(this, objectStream);
            }
            return (T)objectStream.readObject();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java deserialization.", ex);
        }
    }
}

