/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class ConfigUtils {
    public static <IN, OUT> void encodeArrayToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable IN[] values2, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values2 == null) {
            return;
        }
        ConfigUtils.encodeCollectionToConfig(configuration, key, Arrays.asList(values2), mapper);
    }

    public static <IN, OUT> void encodeCollectionToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable Collection<IN> values2, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values2 == null) {
            return;
        }
        List encodedOption = values2.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        configuration.set(key, encodedOption);
    }

    public static <IN, OUT, E extends Throwable> List<OUT> decodeListFromConfig(ReadableConfig configuration, ConfigOption<List<IN>> key, FunctionWithException<IN, OUT, E> mapper) throws E {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        List<IN> encodedString = configuration.get(key);
        if (encodedString == null || encodedString.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<OUT> result = new ArrayList<OUT>(encodedString.size());
        for (IN input : encodedString) {
            result.add(mapper.apply(input));
        }
        return result;
    }

    private ConfigUtils() {
    }
}

