/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.util.ArrayUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;

@ThreadSafe
public class PluginLoader {
    private final ClassLoader pluginClassLoader;

    @VisibleForTesting
    public PluginLoader(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    @VisibleForTesting
    public static ClassLoader createPluginClassLoader(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new PluginClassLoader(pluginDescriptor.getPluginResourceURLs(), parentClassLoader, ArrayUtils.concat(alwaysParentFirstPatterns, pluginDescriptor.getLoaderExcludePatterns()));
    }

    public static PluginLoader create(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new PluginLoader(PluginLoader.createPluginClassLoader(pluginDescriptor, parentClassLoader, alwaysParentFirstPatterns));
    }

    public <P> Iterator<P> load(Class<P> service2) {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.pluginClassLoader);){
            ContextClassLoaderSettingIterator<P> contextClassLoaderSettingIterator = new ContextClassLoaderSettingIterator<P>(ServiceLoader.load(service2, this.pluginClassLoader).iterator(), this.pluginClassLoader);
            return contextClassLoaderSettingIterator;
        }
    }

    private static final class PluginClassLoader
    extends URLClassLoader {
        private static final ClassLoader PLATFORM_OR_BOOTSTRAP_LOADER;
        private final ClassLoader flinkClassLoader;
        private final String[] allowedFlinkPackages;
        private final String[] allowedResourcePrefixes;

        PluginClassLoader(URL[] pluginResourceURLs, ClassLoader flinkClassLoader, String[] allowedFlinkPackages) {
            super(pluginResourceURLs, PLATFORM_OR_BOOTSTRAP_LOADER);
            this.flinkClassLoader = flinkClassLoader;
            this.allowedFlinkPackages = allowedFlinkPackages;
            this.allowedResourcePrefixes = (String[])Arrays.stream(allowedFlinkPackages).map(packageName -> packageName.replace('.', '/')).toArray(String[]::new);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return this.resolveIfNeeded(resolve, loadedClass);
                }
                if (this.isAllowedFlinkClass(name)) {
                    try {
                        return this.resolveIfNeeded(resolve, this.flinkClassLoader.loadClass(name));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return super.loadClass(name, resolve);
            }
        }

        private Class<?> resolveIfNeeded(boolean resolve, Class<?> loadedClass) {
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }

        @Override
        public URL getResource(String name) {
            if (this.isAllowedFlinkResource(name)) {
                return this.flinkClassLoader.getResource(name);
            }
            return super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.isAllowedFlinkResource(name)) {
                return this.flinkClassLoader.getResources(name);
            }
            return super.getResources(name);
        }

        private boolean isAllowedFlinkClass(String name) {
            return Arrays.stream(this.allowedFlinkPackages).anyMatch(name::startsWith);
        }

        private boolean isAllowedFlinkResource(String name) {
            return Arrays.stream(this.allowedResourcePrefixes).anyMatch(name::startsWith);
        }

        static {
            ClassLoader platformLoader = null;
            try {
                platformLoader = (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot retrieve platform classloader on Java 9+", e);
            }
            PLATFORM_OR_BOOTSTRAP_LOADER = platformLoader;
            ClassLoader.registerAsParallelCapable();
        }
    }

    static class ContextClassLoaderSettingIterator<P>
    implements Iterator<P> {
        private final Iterator<P> delegate;
        private final ClassLoader pluginClassLoader;

        ContextClassLoaderSettingIterator(Iterator<P> delegate, ClassLoader pluginClassLoader) {
            this.delegate = delegate;
            this.pluginClassLoader = pluginClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public P next() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.pluginClassLoader);){
                P p = this.delegate.next();
                return p;
            }
        }
    }
}

