/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterIdProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ClusterId {
    private final String id;

    public ClusterId() {
        this(UUID.randomUUID().toString());
    }

    public ClusterId(String uuid) {
        this.id = uuid;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public static ClusterId parseFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ClusterIdProtos.ClusterId.Builder builder = ClusterIdProtos.ClusterId.newBuilder();
            ClusterIdProtos.ClusterId cid = null;
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                cid = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return ClusterId.convert(cid);
        }
        return new ClusterId(Bytes.toString(bytes));
    }

    public ClusterIdProtos.ClusterId convert() {
        ClusterIdProtos.ClusterId.Builder builder = ClusterIdProtos.ClusterId.newBuilder();
        return builder.setClusterId(this.id).build();
    }

    public static ClusterId convert(ClusterIdProtos.ClusterId cid) {
        return new ClusterId(cid.getClusterId());
    }

    public String toString() {
        return this.id;
    }
}

