/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.RegistryFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicyFactory;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.BlockingRpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
class ConnectionImplementation
implements ClusterConnection,
Closeable {
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    private static final Log LOG = LogFactory.getLog(ConnectionImplementation.class);
    private static final String RESOLVE_HOSTNAME_ON_FAIL_KEY = "hbase.resolve.hostnames.on.failure";
    private final boolean hostnamesCanChange;
    private final long pause;
    private final long pauseForCQTBE;
    private boolean useMetaReplicas;
    private final int metaReplicaCallTimeoutScanInMicroSecond;
    private final int numTries;
    final int rpcTimeout;
    private static volatile NonceGenerator nonceGenerator = null;
    private static final Object nonceGeneratorCreateLock = new Object();
    private final AsyncProcess asyncProcess;
    private final ServerStatisticTracker stats;
    private volatile boolean closed;
    private volatile boolean aborted;
    ClusterStatusListener clusterStatusListener;
    private final Object metaRegionLock = new Object();
    private final Object masterAndZKLock = new Object();
    private volatile ExecutorService batchPool = null;
    private volatile ExecutorService metaLookupPool = null;
    private volatile boolean cleanupPool = false;
    private final Configuration conf;
    private final ConnectionConfiguration connectionConfig;
    private final RpcClient rpcClient;
    private final MetaCache metaCache;
    private final MetricsConnection metrics;
    protected User user;
    private final RpcRetryingCallerFactory rpcCallerFactory;
    private final RpcControllerFactory rpcControllerFactory;
    private final RetryingCallerInterceptor interceptor;
    Registry registry;
    private final ClientBackoffPolicy backoffPolicy;
    private final String alternateBufferedMutatorClassName;
    protected String clusterId = null;
    private final ConcurrentMap<String, Object> stubs = new ConcurrentHashMap<String, Object>();
    private ZooKeeperKeepAliveConnection keepAliveZookeeper;
    private AtomicInteger keepAliveZookeeperUserCount = new AtomicInteger(0);
    final MasterServiceState masterServiceState = new MasterServiceState(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionImplementation(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.user = user;
        this.batchPool = pool;
        this.connectionConfig = new ConnectionConfiguration(conf);
        this.closed = false;
        this.pause = conf.getLong("hbase.client.pause", 100L);
        long configuredPauseForCQTBE = conf.getLong("hbase.client.pause.cqtbe", this.pause);
        if (configuredPauseForCQTBE < this.pause) {
            LOG.warn((Object)("The hbase.client.pause.cqtbe setting: " + configuredPauseForCQTBE + " is smaller than " + "hbase.client.pause" + ", will use " + this.pause + " instead."));
            this.pauseForCQTBE = this.pause;
        } else {
            this.pauseForCQTBE = configuredPauseForCQTBE;
        }
        this.useMetaReplicas = conf.getBoolean("hbase.meta.replicas.use", false);
        this.metaReplicaCallTimeoutScanInMicroSecond = this.connectionConfig.getMetaReplicaCallTimeoutMicroSecondScan();
        this.numTries = ConnectionUtils.retries2Attempts(this.connectionConfig.getRetriesNumber());
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        if (conf.getBoolean("hbase.client.nonces.enabled", true)) {
            Object object = nonceGeneratorCreateLock;
            synchronized (object) {
                if (nonceGenerator == null) {
                    nonceGenerator = PerClientRandomNonceGenerator.get();
                }
            }
        } else {
            nonceGenerator = ConnectionUtils.NO_NONCE_GENERATOR;
        }
        this.stats = ServerStatisticTracker.create(conf);
        this.interceptor = new RetryingCallerInterceptorFactory(conf).build();
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(conf, this.interceptor, this.stats);
        this.backoffPolicy = ClientBackoffPolicyFactory.create(conf);
        this.asyncProcess = new AsyncProcess(this, conf, this.rpcCallerFactory, false, this.rpcControllerFactory);
        this.metrics = conf.getBoolean("hbase.client.metrics.enable", false) ? new MetricsConnection(this) : null;
        this.metaCache = new MetaCache(this.metrics);
        boolean shouldListen = conf.getBoolean("hbase.status.published", false);
        this.hostnamesCanChange = conf.getBoolean(RESOLVE_HOSTNAME_ON_FAIL_KEY, true);
        Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
        this.alternateBufferedMutatorClassName = this.conf.get("hbase.client.bufferedmutator.classname");
        try {
            this.registry = this.setupRegistry();
            this.retrieveClusterId();
            this.rpcClient = RpcClientFactory.createClient(this.conf, this.clusterId, this.metrics);
            if (shouldListen) {
                if (listenerClass == null) {
                    LOG.warn((Object)"hbase.status.published is true, but hbase.status.listener.class is not set - not listening status");
                } else {
                    this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            ConnectionImplementation.this.clearCaches(sn);
                            ConnectionImplementation.this.rpcClient.cancelConnections(sn);
                        }
                    }, conf, listenerClass);
                }
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)"connection construction failed", e);
            this.close();
            throw e;
        }
    }

    @VisibleForTesting
    void setUseMetaReplicas(boolean useMetaReplicas) {
        this.useMetaReplicas = useMetaReplicas;
    }

    @VisibleForTesting
    static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        ConnectionImplementation connImpl = (ConnectionImplementation)conn;
        NonceGenerator ng = connImpl.getNonceGenerator();
        LOG.warn((Object)("Nonce generator is being replaced by test code for " + cnm.getClass().getName()));
        nonceGenerator = cnm;
        return ng;
    }

    @Override
    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.getBatchPool());
    }

    @Override
    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new TableBuilderBase(tableName, this.connectionConfig){

            @Override
            public Table build() {
                return new HTable(ConnectionImplementation.this, this, ConnectionImplementation.this.rpcCallerFactory, ConnectionImplementation.this.rpcControllerFactory, pool);
            }
        };
    }

    @Override
    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
        String implementationClassName;
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        if (params.getPool() == null) {
            params.pool(HTable.getDefaultExecutor(this.getConfiguration()));
        }
        if (params.getWriteBufferSize() == -1L) {
            params.writeBufferSize(this.connectionConfig.getWriteBufferSize());
        }
        if (params.getMaxKeyValueSize() == -1) {
            params.maxKeyValueSize(this.connectionConfig.getMaxKeyValueSize());
        }
        if ((implementationClassName = params.getImplementationClassName()) == null) {
            implementationClassName = this.alternateBufferedMutatorClassName;
        }
        if (implementationClassName == null) {
            return new BufferedMutatorImpl(this, this.rpcCallerFactory, this.rpcControllerFactory, params);
        }
        try {
            return (BufferedMutator)ReflectionUtils.newInstance(Class.forName(implementationClassName), this, this.rpcCallerFactory, this.rpcControllerFactory, params);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BufferedMutator getBufferedMutator(TableName tableName) {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    @Override
    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new HRegionLocator(tableName, this);
    }

    @Override
    public Admin getAdmin() throws IOException {
        return new HBaseAdmin(this);
    }

    @Override
    public MetricsConnection getConnectionMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() {
        if (this.batchPool == null) {
            ConnectionImplementation connectionImplementation = this;
            synchronized (connectionImplementation) {
                if (this.batchPool == null) {
                    int threads = this.conf.getInt("hbase.hconnection.threads.max", 256);
                    this.batchPool = this.getThreadPool(threads, threads, "-shared", null);
                    this.cleanupPool = true;
                }
            }
        }
        return this.batchPool;
    }

    private ExecutorService getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        BlockingQueue<Runnable> workQueue = passedWorkQueue;
        if (workQueue == null) {
            workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
            coreThreads = maxThreads;
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory(this.toString() + nameHint));
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getMetaLookupPool() {
        if (this.metaLookupPool == null) {
            ConnectionImplementation connectionImplementation = this;
            synchronized (connectionImplementation) {
                if (this.metaLookupPool == null) {
                    int threads = this.conf.getInt("hbase.hconnection.meta.lookup.threads.max", 128);
                    this.metaLookupPool = this.getThreadPool(threads, threads, "-metaLookup-shared-", new LinkedBlockingQueue<Runnable>());
                }
            }
        }
        return this.metaLookupPool;
    }

    protected ExecutorService getCurrentMetaLookupPool() {
        return this.metaLookupPool;
    }

    protected ExecutorService getCurrentBatchPool() {
        return this.batchPool;
    }

    private void shutdownPools() {
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.shutdownBatchPool(this.batchPool);
        }
        if (this.metaLookupPool != null && !this.metaLookupPool.isShutdown()) {
            this.shutdownBatchPool(this.metaLookupPool);
        }
    }

    private void shutdownBatchPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
        }
    }

    private Registry setupRegistry() throws IOException {
        return RegistryFactory.getRegistry(this);
    }

    @VisibleForTesting
    RpcClient getRpcClient() {
        return this.rpcClient;
    }

    public String toString() {
        return "hconnection-0x" + Integer.toHexString(this.hashCode());
    }

    protected void retrieveClusterId() {
        if (this.clusterId != null) {
            return;
        }
        this.clusterId = this.registry.getClusterId();
        if (this.clusterId == null) {
            this.clusterId = "default-cluster";
            LOG.debug((Object)("clusterid came back null, using default " + this.clusterId));
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
        try {
            if (ZKUtil.checkExists(zkw, zkw.znodePaths.baseZNode) == -1) {
                String errorMsg = "The node " + zkw.znodePaths.baseZNode + " is not in ZooKeeper. It should have been written by the master. Check the value configured in 'zookeeper.znode.parent'. There could be a mismatch with the one configured in the master.";
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg);
            }
        }
        catch (KeeperException e) {
            String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
            LOG.error((Object)errorMsg);
            throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
        }
    }

    @Override
    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        MasterKeepAliveConnection m = this.getKeepAliveMasterService();
        m.close();
        return true;
    }

    @Override
    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return reload ? this.relocateRegion(tableName, row) : this.locateRegion(tableName, row);
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.getTableState(tableName).inStates(TableState.State.ENABLED);
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.getTableState(tableName).inStates(TableState.State.DISABLED);
    }

    @Override
    public boolean isTableAvailable(TableName tableName, @Nullable byte[][] splitKeys) throws IOException {
        if (this.closed) {
            throw new IOException(this.toString() + " closed");
        }
        try {
            if (!this.isTableEnabled(tableName)) {
                LOG.debug((Object)("Table " + tableName + " not enabled"));
                return false;
            }
            List<Pair<RegionInfo, ServerName>> locations = MetaTableAccessor.getTableRegionsAndLocations(this, tableName, true);
            int notDeployed = 0;
            int regionCount = 0;
            block2: for (Pair<RegionInfo, ServerName> pair : locations) {
                RegionInfo info = pair.getFirst();
                if (pair.getSecond() == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Table " + tableName + " has not deployed region " + pair.getFirst().getEncodedName()));
                    }
                    ++notDeployed;
                    continue;
                }
                if (splitKeys != null && !Bytes.equals(info.getStartKey(), HConstants.EMPTY_BYTE_ARRAY)) {
                    for (byte[] splitKey : splitKeys) {
                        if (!Bytes.equals(info.getStartKey(), splitKey)) continue;
                        ++regionCount;
                        continue block2;
                    }
                    continue;
                }
                ++regionCount;
            }
            if (notDeployed > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Table " + tableName + " has " + notDeployed + " regions"));
                }
                return false;
            }
            if (splitKeys != null && regionCount != splitKeys.length + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Table " + tableName + " expected to have " + (splitKeys.length + 1) + " regions, but only " + regionCount + " available"));
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Table " + tableName + " should be available"));
            }
            return true;
        }
        catch (TableNotFoundException tnfe) {
            LOG.warn((Object)("Table " + tableName + " not enabled, it is not exists"));
            return false;
        }
    }

    @Override
    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        RegionLocations locations = this.locateRegion(HRegionInfo.getTable(regionName), HRegionInfo.getStartKey(regionName), false, true);
        return locations == null ? null : locations.getRegionLocation();
    }

    @Override
    public boolean isDeadServer(ServerName sn) {
        if (this.clusterStatusListener == null) {
            return false;
        }
        return this.clusterStatusListener.isDeadServer(sn);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.locateRegions(tableName, false, true);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        List<RegionInfo> regions = MetaTableAccessor.getTableRegions(this, tableName, !offlined);
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        for (RegionInfo regionInfo : regions) {
            RegionLocations list = this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true);
            if (list == null) continue;
            for (HRegionLocation loc : list.getRegionLocations()) {
                if (loc == null) continue;
                locations.add(loc);
            }
        }
        return locations;
    }

    @Override
    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        RegionLocations locations = this.locateRegion(tableName, row, true, true);
        return locations == null ? null : locations.getRegionLocation();
    }

    @Override
    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        RegionLocations locations = this.relocateRegion(tableName, row, 0);
        return locations == null ? null : locations.getRegionLocation(0);
    }

    @Override
    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        if (!tableName.equals(TableName.META_TABLE_NAME) && this.isTableDisabled(tableName)) {
            throw new TableNotEnabledException(tableName.getNameAsString() + " is disabled.");
        }
        return this.locateRegion(tableName, row, false, true, replicaId);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry, 0);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        if (this.closed) {
            throw new DoNotRetryIOException(this.toString() + " closed");
        }
        if (tableName == null || tableName.getName().length == 0) {
            throw new IllegalArgumentException("table name cannot be null or zero length");
        }
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return this.locateMeta(tableName, useCache, replicaId);
        }
        return this.locateRegionInMeta(tableName, row, useCache, retry, replicaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionLocations locateMeta(TableName tableName, boolean useCache, int replicaId) throws IOException {
        byte[] metaCacheKey = HConstants.EMPTY_START_ROW;
        RegionLocations locations = null;
        if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
            return locations;
        }
        Object object = this.metaRegionLock;
        synchronized (object) {
            if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
                return locations;
            }
            locations = this.registry.getMetaRegionLocation();
            if (locations != null) {
                this.cacheLocation(tableName, locations);
            }
        }
        return locations;
    }

    private RegionLocations locateRegionInMeta(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        RegionLocations locations;
        if (useCache && (locations = this.getCachedLocation(tableName, row)) != null && locations.getRegionLocation(replicaId) != null) {
            return locations;
        }
        byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
        Scan s = new Scan();
        s.setReversed(true);
        s.withStartRow(metaKey);
        s.addFamily(HConstants.CATALOG_FAMILY);
        if (this.useMetaReplicas) {
            s.setConsistency(Consistency.TIMELINE);
        }
        int maxAttempts = retry ? this.numTries : 1;
        int tries = 0;
        while (true) {
            if (tries >= maxAttempts) {
                throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " in " + tableName + " after " + tries + " tries.");
            }
            if (useCache) {
                RegionLocations locations2 = this.getCachedLocation(tableName, row);
                if (locations2 != null && locations2.getRegionLocation(replicaId) != null) {
                    return locations2;
                }
            } else {
                this.metaCache.clearCache(tableName, row, replicaId);
            }
            long pauseBase = this.pause;
            try {
                Result regionInfoRow = null;
                s.resetMvccReadPoint();
                s.setOneRowLimit();
                try (ReversedClientScanner rcs = new ReversedClientScanner(this.conf, s, TableName.META_TABLE_NAME, this, this.rpcCallerFactory, this.rpcControllerFactory, this.getMetaLookupPool(), this.metaReplicaCallTimeoutScanInMicroSecond);){
                    regionInfoRow = rcs.next();
                }
                if (regionInfoRow == null) {
                    throw new TableNotFoundException(tableName);
                }
                RegionLocations locations3 = MetaTableAccessor.getRegionLocations(regionInfoRow);
                if (locations3 == null || locations3.getRegionLocation(replicaId) == null) {
                    throw new IOException("HRegionInfo was null in " + tableName + ", row=" + regionInfoRow);
                }
                HRegionInfo regionInfo = locations3.getRegionLocation(replicaId).getRegionInfo();
                if (regionInfo == null) {
                    throw new IOException("HRegionInfo was null or empty in " + TableName.META_TABLE_NAME + ", row=" + regionInfoRow);
                }
                if (!regionInfo.getTable().equals(tableName)) {
                    throw new TableNotFoundException("Region of '" + regionInfo.getRegionNameAsString() + "' is expected in the table of '" + tableName + "', but hbase:meta says it is in the table of '" + regionInfo.getTable() + "'. hbase:meta might be damaged.");
                }
                if (regionInfo.isSplit()) {
                    throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                }
                if (regionInfo.isOffline()) {
                    throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                }
                ServerName serverName = locations3.getRegionLocation(replicaId).getServerName();
                if (serverName == null) {
                    throw new NoServerForRegionException("No server address listed in " + TableName.META_TABLE_NAME + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary(row));
                }
                if (this.isDeadServer(serverName)) {
                    throw new RegionServerStoppedException("hbase:meta says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                }
                this.cacheLocation(tableName, locations3);
                return locations3;
            }
            catch (TableNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                ExceptionUtil.rethrowIfInterrupt(e);
                if (e instanceof RemoteException) {
                    e = ((RemoteException)((Object)e)).unwrapRemoteException();
                }
                if (e instanceof CallQueueTooBigException) {
                    pauseBase = this.pauseForCQTBE;
                }
                if (tries < maxAttempts - 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("locateRegionInMeta parentTable=" + TableName.META_TABLE_NAME + ", metaLocation=, attempt=" + tries + " of " + maxAttempts + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(pauseBase, tries) + " because: " + e.getMessage()));
                    }
                } else {
                    throw e;
                }
                if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                    this.relocateRegion(TableName.META_TABLE_NAME, metaKey, replicaId);
                }
                try {
                    Thread.sleep(ConnectionUtils.getPauseTime(pauseBase, tries));
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException("Giving up trying to location region in meta: thread is interrupted.");
                }
                ++tries;
                continue;
            }
            break;
        }
    }

    @Override
    public void cacheLocation(TableName tableName, RegionLocations location) {
        this.metaCache.cacheLocation(tableName, location);
    }

    RegionLocations getCachedLocation(TableName tableName, byte[] row) {
        return this.metaCache.getCachedLocation(tableName, row);
    }

    public void clearRegionCache(TableName tableName, byte[] row) {
        this.metaCache.clearCache(tableName, row);
    }

    @Override
    public void clearCaches(ServerName serverName) {
        this.metaCache.clearCache(serverName);
    }

    @Override
    public void clearRegionCache() {
        this.metaCache.clearCache();
    }

    @Override
    public void clearRegionCache(TableName tableName) {
        this.metaCache.clearCache(tableName);
    }

    private void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
        this.metaCache.cacheLocation(tableName, source, location);
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        if (this.isDeadServer(serverName)) {
            throw new RegionServerStoppedException(serverName + " is dead.");
        }
        String key = ConnectionUtils.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName, this.hostnamesCanChange);
        return (AdminProtos.AdminService.BlockingInterface)CollectionUtils.computeIfAbsentEx(this.stubs, (Object)key, () -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
            return AdminProtos.AdminService.newBlockingStub((BlockingRpcChannel)channel);
        });
    }

    @Override
    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        if (this.isDeadServer(serverName)) {
            throw new RegionServerStoppedException(serverName + " is dead.");
        }
        String key = ConnectionUtils.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), serverName, this.hostnamesCanChange);
        return (ClientProtos.ClientService.BlockingInterface)CollectionUtils.computeIfAbsentEx(this.stubs, (Object)key, () -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
            return ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
        Object object = this.masterAndZKLock;
        synchronized (object) {
            if (this.keepAliveZookeeper == null) {
                if (this.closed) {
                    throw new IOException(this.toString() + " closed");
                }
                this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
            }
            this.keepAliveZookeeperUserCount.addAndGet(1);
            return this.keepAliveZookeeper;
        }
    }

    void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
        if (zkw == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeZooKeeperWatcher() {
        Object object = this.masterAndZKLock;
        synchronized (object) {
            if (this.keepAliveZookeeper != null) {
                LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                this.keepAliveZookeeper.internalClose();
                this.keepAliveZookeeper = null;
            }
            this.keepAliveZookeeperUserCount.set(0);
        }
    }

    @Override
    public MasterProtos.MasterService.BlockingInterface getMaster() throws MasterNotRunningException {
        return this.getKeepAliveMasterService();
    }

    private void resetMasterServiceState(MasterServiceState mss) {
        ++mss.userCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        Object object = this.masterAndZKLock;
        synchronized (object) {
            if (!this.isKeepAliveMasterConnectedAndRunning(this.masterServiceState)) {
                MasterServiceStubMaker stubMaker = new MasterServiceStubMaker();
                try {
                    this.masterServiceState.stub = stubMaker.makeStub();
                }
                catch (MasterNotRunningException ex) {
                    throw ex;
                }
                catch (IOException e) {
                    throw new MasterNotRunningException(e);
                }
            }
            this.resetMasterServiceState(this.masterServiceState);
        }
        final MasterProtos.MasterService.BlockingInterface stub = this.masterServiceState.stub;
        return new MasterKeepAliveConnection(){
            MasterServiceState mss;
            {
                this.mss = ConnectionImplementation.this.masterServiceState;
            }

            public MasterProtos.AbortProcedureResponse abortProcedure(RpcController controller, MasterProtos.AbortProcedureRequest request) throws ServiceException {
                return stub.abortProcedure(controller, request);
            }

            public MasterProtos.GetProceduresResponse getProcedures(RpcController controller, MasterProtos.GetProceduresRequest request) throws ServiceException {
                return stub.getProcedures(controller, request);
            }

            public MasterProtos.GetLocksResponse getLocks(RpcController controller, MasterProtos.GetLocksRequest request) throws ServiceException {
                return stub.getLocks(controller, request);
            }

            public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest request) throws ServiceException {
                return stub.addColumn(controller, request);
            }

            public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest request) throws ServiceException {
                return stub.deleteColumn(controller, request);
            }

            public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest request) throws ServiceException {
                return stub.modifyColumn(controller, request);
            }

            public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest request) throws ServiceException {
                return stub.moveRegion(controller, request);
            }

            public MasterProtos.MergeTableRegionsResponse mergeTableRegions(RpcController controller, MasterProtos.MergeTableRegionsRequest request) throws ServiceException {
                return stub.mergeTableRegions(controller, request);
            }

            public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest request) throws ServiceException {
                return stub.assignRegion(controller, request);
            }

            public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest request) throws ServiceException {
                return stub.unassignRegion(controller, request);
            }

            public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
                return stub.offlineRegion(controller, request);
            }

            public MasterProtos.SplitTableRegionResponse splitRegion(RpcController controller, MasterProtos.SplitTableRegionRequest request) throws ServiceException {
                return stub.splitRegion(controller, request);
            }

            public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
                return stub.deleteTable(controller, request);
            }

            public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
                return stub.truncateTable(controller, request);
            }

            public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
                return stub.enableTable(controller, request);
            }

            public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
                return stub.disableTable(controller, request);
            }

            public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest request) throws ServiceException {
                return stub.modifyTable(controller, request);
            }

            public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest request) throws ServiceException {
                return stub.createTable(controller, request);
            }

            public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
                return stub.shutdown(controller, request);
            }

            public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
                return stub.stopMaster(controller, request);
            }

            public MasterProtos.IsInMaintenanceModeResponse isMasterInMaintenanceMode(RpcController controller, MasterProtos.IsInMaintenanceModeRequest request) throws ServiceException {
                return stub.isMasterInMaintenanceMode(controller, request);
            }

            public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
                return stub.balance(controller, request);
            }

            public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest request) throws ServiceException {
                return stub.setBalancerRunning(controller, request);
            }

            public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
                return stub.normalize(controller, request);
            }

            public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
                return stub.setNormalizerRunning(controller, request);
            }

            public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController controller, MasterProtos.RunCatalogScanRequest request) throws ServiceException {
                return stub.runCatalogScan(controller, request);
            }

            public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                return stub.enableCatalogJanitor(controller, request);
            }

            public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                return stub.isCatalogJanitorEnabled(controller, request);
            }

            public MasterProtos.RunCleanerChoreResponse runCleanerChore(RpcController controller, MasterProtos.RunCleanerChoreRequest request) throws ServiceException {
                return stub.runCleanerChore(controller, request);
            }

            public MasterProtos.SetCleanerChoreRunningResponse setCleanerChoreRunning(RpcController controller, MasterProtos.SetCleanerChoreRunningRequest request) throws ServiceException {
                return stub.setCleanerChoreRunning(controller, request);
            }

            public MasterProtos.IsCleanerChoreEnabledResponse isCleanerChoreEnabled(RpcController controller, MasterProtos.IsCleanerChoreEnabledRequest request) throws ServiceException {
                return stub.isCleanerChoreEnabled(controller, request);
            }

            public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                return stub.execMasterService(controller, request);
            }

            public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
                return stub.snapshot(controller, request);
            }

            public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
                return stub.getCompletedSnapshots(controller, request);
            }

            public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
                return stub.deleteSnapshot(controller, request);
            }

            public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
                return stub.isSnapshotDone(controller, request);
            }

            public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
                return stub.restoreSnapshot(controller, request);
            }

            public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                return stub.execProcedure(controller, request);
            }

            public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                return stub.execProcedureWithRet(controller, request);
            }

            public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
                return stub.isProcedureDone(controller, request);
            }

            public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
                return stub.getProcedureResult(controller, request);
            }

            public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                return stub.isMasterRunning(controller, request);
            }

            public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
                return stub.modifyNamespace(controller, request);
            }

            public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
                return stub.createNamespace(controller, request);
            }

            public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
                return stub.deleteNamespace(controller, request);
            }

            public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
                return stub.getNamespaceDescriptor(controller, request);
            }

            public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
                return stub.listNamespaceDescriptors(controller, request);
            }

            public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
                return stub.listTableDescriptorsByNamespace(controller, request);
            }

            public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
                return stub.listTableNamesByNamespace(controller, request);
            }

            public MasterProtos.GetTableStateResponse getTableState(RpcController controller, MasterProtos.GetTableStateRequest request) throws ServiceException {
                return stub.getTableState(controller, request);
            }

            @Override
            public void close() {
                ConnectionImplementation.release(this.mss);
            }

            public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                return stub.getSchemaAlterStatus(controller, request);
            }

            public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest request) throws ServiceException {
                return stub.getTableDescriptors(controller, request);
            }

            public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest request) throws ServiceException {
                return stub.getTableNames(controller, request);
            }

            public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest request) throws ServiceException {
                return stub.getClusterStatus(controller, request);
            }

            public MasterProtos.SetQuotaResponse setQuota(RpcController controller, MasterProtos.SetQuotaRequest request) throws ServiceException {
                return stub.setQuota(controller, request);
            }

            public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
                return stub.getLastMajorCompactionTimestamp(controller, request);
            }

            public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
                return stub.getLastMajorCompactionTimestampForRegion(controller, request);
            }

            public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
                return stub.isBalancerEnabled(controller, request);
            }

            public MasterProtos.SetSplitOrMergeEnabledResponse setSplitOrMergeEnabled(RpcController controller, MasterProtos.SetSplitOrMergeEnabledRequest request) throws ServiceException {
                return stub.setSplitOrMergeEnabled(controller, request);
            }

            public MasterProtos.IsSplitOrMergeEnabledResponse isSplitOrMergeEnabled(RpcController controller, MasterProtos.IsSplitOrMergeEnabledRequest request) throws ServiceException {
                return stub.isSplitOrMergeEnabled(controller, request);
            }

            public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) throws ServiceException {
                return stub.isNormalizerEnabled(controller, request);
            }

            public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
                return stub.getSecurityCapabilities(controller, request);
            }

            public ReplicationProtos.AddReplicationPeerResponse addReplicationPeer(RpcController controller, ReplicationProtos.AddReplicationPeerRequest request) throws ServiceException {
                return stub.addReplicationPeer(controller, request);
            }

            public ReplicationProtos.RemoveReplicationPeerResponse removeReplicationPeer(RpcController controller, ReplicationProtos.RemoveReplicationPeerRequest request) throws ServiceException {
                return stub.removeReplicationPeer(controller, request);
            }

            public ReplicationProtos.EnableReplicationPeerResponse enableReplicationPeer(RpcController controller, ReplicationProtos.EnableReplicationPeerRequest request) throws ServiceException {
                return stub.enableReplicationPeer(controller, request);
            }

            public ReplicationProtos.DisableReplicationPeerResponse disableReplicationPeer(RpcController controller, ReplicationProtos.DisableReplicationPeerRequest request) throws ServiceException {
                return stub.disableReplicationPeer(controller, request);
            }

            public MasterProtos.ListDecommissionedRegionServersResponse listDecommissionedRegionServers(RpcController controller, MasterProtos.ListDecommissionedRegionServersRequest request) throws ServiceException {
                return stub.listDecommissionedRegionServers(controller, request);
            }

            public MasterProtos.DecommissionRegionServersResponse decommissionRegionServers(RpcController controller, MasterProtos.DecommissionRegionServersRequest request) throws ServiceException {
                return stub.decommissionRegionServers(controller, request);
            }

            public MasterProtos.RecommissionRegionServerResponse recommissionRegionServer(RpcController controller, MasterProtos.RecommissionRegionServerRequest request) throws ServiceException {
                return stub.recommissionRegionServer(controller, request);
            }

            public ReplicationProtos.GetReplicationPeerConfigResponse getReplicationPeerConfig(RpcController controller, ReplicationProtos.GetReplicationPeerConfigRequest request) throws ServiceException {
                return stub.getReplicationPeerConfig(controller, request);
            }

            public ReplicationProtos.UpdateReplicationPeerConfigResponse updateReplicationPeerConfig(RpcController controller, ReplicationProtos.UpdateReplicationPeerConfigRequest request) throws ServiceException {
                return stub.updateReplicationPeerConfig(controller, request);
            }

            public ReplicationProtos.ListReplicationPeersResponse listReplicationPeers(RpcController controller, ReplicationProtos.ListReplicationPeersRequest request) throws ServiceException {
                return stub.listReplicationPeers(controller, request);
            }

            public QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizes(RpcController controller, QuotaProtos.GetSpaceQuotaRegionSizesRequest request) throws ServiceException {
                return stub.getSpaceQuotaRegionSizes(controller, request);
            }

            public QuotaProtos.GetQuotaStatesResponse getQuotaStates(RpcController controller, QuotaProtos.GetQuotaStatesRequest request) throws ServiceException {
                return stub.getQuotaStates(controller, request);
            }

            public MasterProtos.ListDeadServersResponse listDeadServers(RpcController controller, MasterProtos.ListDeadServersRequest request) throws ServiceException {
                return stub.listDeadServers(controller, request);
            }

            public MasterProtos.ClearDeadServersResponse clearDeadServers(RpcController controller, MasterProtos.ClearDeadServersRequest request) throws ServiceException {
                return stub.clearDeadServers(controller, request);
            }
        };
    }

    private static void release(MasterServiceState mss) {
        if (mss != null && mss.connection != null) {
            ((ConnectionImplementation)mss.connection).releaseMaster(mss);
        }
    }

    private boolean isKeepAliveMasterConnectedAndRunning(MasterServiceState mss) {
        if (mss.getStub() == null) {
            return false;
        }
        try {
            return mss.isMasterRunning();
        }
        catch (UndeclaredThrowableException e) {
            LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
            return false;
        }
        catch (IOException se) {
            LOG.warn((Object)"Checking master connection", (Throwable)se);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMaster(MasterServiceState mss) {
        if (mss.getStub() == null) {
            return;
        }
        Object object = this.masterAndZKLock;
        synchronized (object) {
            --mss.userCount;
        }
    }

    private void closeMasterService(MasterServiceState mss) {
        if (mss.getStub() != null) {
            LOG.info((Object)("Closing master protocol: " + mss));
            mss.clearStub();
        }
        mss.userCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMaster() {
        Object object = this.masterAndZKLock;
        synchronized (object) {
            this.closeMasterService(this.masterServiceState);
        }
    }

    void updateCachedLocation(HRegionInfo hri, ServerName source, ServerName serverName, long seqNum) {
        HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
        this.cacheLocation(hri.getTable(), source, newHrl);
    }

    @Override
    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.metaCache.clearCache(location);
    }

    @Override
    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        if (rowkey == null || tableName == null) {
            LOG.warn((Object)("Coding error, see method javadoc. row=" + (rowkey == null ? "null" : (Object)rowkey) + ", tableName=" + (tableName == null ? "null" : tableName)));
            return;
        }
        if (source == null) {
            return;
        }
        if (regionName == null) {
            if (this.metrics != null) {
                this.metrics.incrCacheDroppingExceptions(exception);
            }
            this.metaCache.clearCache(tableName, rowkey, source);
            return;
        }
        RegionLocations oldLocations = this.getCachedLocation(tableName, rowkey);
        HRegionLocation oldLocation = null;
        if (oldLocations != null) {
            oldLocation = oldLocations.getRegionLocationByRegionName(regionName);
        }
        if (oldLocation == null || !source.equals((Object)oldLocation.getServerName())) {
            return;
        }
        HRegionInfo regionInfo = oldLocation.getRegionInfo();
        Throwable cause = ClientExceptionsUtil.findException(exception);
        if (cause != null) {
            if (!ClientExceptionsUtil.isMetaClearingException(cause)) {
                return;
            }
            if (cause instanceof RegionMovedException) {
                RegionMovedException rme = (RegionMovedException)cause;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostAndPort()));
                }
                this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
                return;
            }
        }
        if (this.metrics != null) {
            this.metrics.incrCacheDroppingExceptions(exception);
        }
        this.metaCache.clearCache(regionInfo);
    }

    @Override
    public AsyncProcess getAsyncProcess() {
        return this.asyncProcess;
    }

    @Override
    public ServerStatisticTracker getStatisticsTracker() {
        return this.stats;
    }

    @Override
    public ClientBackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    @VisibleForTesting
    int getNumberOfCachedRegionLocations(TableName tableName) {
        return this.metaCache.getNumberOfCachedRegionLocations(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(String msg, Throwable t) {
        if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                    this.closeZooKeeperWatcher();
                }
            }
        } else {
            if (t != null) {
                LOG.fatal((Object)msg, t);
            } else {
                LOG.fatal((Object)msg);
            }
            this.aborted = true;
            this.close();
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        return this.registry.getCurrentNrHRS();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closeMaster();
        this.shutdownPools();
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        this.closed = true;
        this.closeZooKeeperWatcher();
        this.stubs.clear();
        if (this.clusterStatusListener != null) {
            this.clusterStatusListener.close();
        }
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public NonceGenerator getNonceGenerator() {
        return nonceGenerator;
    }

    @Override
    public TableState getTableState(TableName tableName) throws IOException {
        if (this.closed) {
            throw new IOException(this.toString() + " closed");
        }
        TableState tableState = MetaTableAccessor.getTableState(this, tableName);
        if (tableState == null) {
            throw new TableNotFoundException(tableName);
        }
        return tableState;
    }

    @Override
    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return RpcRetryingCallerFactory.instantiate(conf, this.interceptor, this.getStatisticsTracker());
    }

    @Override
    public boolean hasCellBlockSupport() {
        return this.rpcClient.hasCellBlockSupport();
    }

    @Override
    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfig;
    }

    @Override
    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return this.rpcCallerFactory;
    }

    @Override
    public RpcControllerFactory getRpcControllerFactory() {
        return this.rpcControllerFactory;
    }

    private final class MasterServiceStubMaker {
        private MasterServiceStubMaker() {
        }

        private void isMasterRunning(MasterProtos.MasterService.BlockingInterface stub) throws IOException {
            try {
                stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
            catch (ServiceException e) {
                throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MasterProtos.MasterService.BlockingInterface makeStubNoRetries() throws IOException, KeeperException {
            ZooKeeperKeepAliveConnection zkw;
            try {
                zkw = ConnectionImplementation.this.getKeepAliveZooKeeperWatcher();
            }
            catch (IOException e) {
                ExceptionUtil.rethrowIfInterrupt(e);
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
            }
            try {
                ConnectionImplementation.this.checkIfBaseNodeAvailable(zkw);
                ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                if (sn == null) {
                    String msg = "ZooKeeper available but no active master location found";
                    LOG.info((Object)msg);
                    throw new MasterNotRunningException(msg);
                }
                if (ConnectionImplementation.this.isDeadServer(sn)) {
                    throw new MasterNotRunningException(sn + " is dead.");
                }
                String key = ConnectionUtils.getStubKey(MasterProtos.MasterService.getDescriptor().getName(), sn, ConnectionImplementation.this.hostnamesCanChange);
                MasterProtos.MasterService.BlockingInterface stub = (MasterProtos.MasterService.BlockingInterface)CollectionUtils.computeIfAbsentEx((ConcurrentMap)ConnectionImplementation.this.stubs, (Object)key, () -> {
                    BlockingRpcChannel channel = ConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, ConnectionImplementation.this.user, ConnectionImplementation.this.rpcTimeout);
                    return MasterProtos.MasterService.newBlockingStub((BlockingRpcChannel)channel);
                });
                this.isMasterRunning(stub);
                MasterProtos.MasterService.BlockingInterface blockingInterface = stub;
                return blockingInterface;
            }
            finally {
                zkw.close();
            }
        }

        MasterProtos.MasterService.BlockingInterface makeStub() throws IOException {
            Object object = ConnectionImplementation.this.masterAndZKLock;
            synchronized (object) {
                Throwable exceptionCaught = null;
                if (!ConnectionImplementation.this.closed) {
                    try {
                        return this.makeStubNoRetries();
                    }
                    catch (IOException e) {
                        exceptionCaught = e;
                    }
                    catch (KeeperException e) {
                        exceptionCaught = e;
                    }
                    throw new MasterNotRunningException((Exception)exceptionCaught);
                }
                throw new DoNotRetryIOException("Connection was closed while trying to get master");
            }
        }
    }

    static class ServerErrorTracker {
        private final ConcurrentMap<ServerName, ServerErrors> errorsByServer = new ConcurrentHashMap<ServerName, ServerErrors>();
        private final long canRetryUntil;
        private final int maxTries;
        private final long startTrackingTime;

        public ServerErrorTracker(long timeout, int maxTries) {
            this.maxTries = maxTries;
            this.canRetryUntil = EnvironmentEdgeManager.currentTime() + timeout;
            this.startTrackingTime = new Date().getTime();
        }

        boolean canTryMore(int numAttempt) {
            return numAttempt < this.maxTries || this.maxTries > 1 && EnvironmentEdgeManager.currentTime() < this.canRetryUntil;
        }

        long calculateBackoffTime(ServerName server, long basePause) {
            ServerErrors errorStats = (ServerErrors)this.errorsByServer.get(server);
            long result = errorStats != null ? ConnectionUtils.getPauseTime(basePause, Math.max(0, errorStats.getCount() - 1)) : 0L;
            return result;
        }

        void reportServerError(ServerName server) {
            ((ServerErrors)CollectionUtils.computeIfAbsent(this.errorsByServer, (Object)server, () -> new ServerErrors())).addError();
        }

        long getStartTrackingTime() {
            return this.startTrackingTime;
        }

        private static class ServerErrors {
            private final AtomicInteger retries = new AtomicInteger(0);

            private ServerErrors() {
            }

            public int getCount() {
                return this.retries.get();
            }

            public void addError() {
                this.retries.incrementAndGet();
            }
        }
    }

    static class MasterServiceState {
        Connection connection;
        MasterProtos.MasterService.BlockingInterface stub;
        int userCount;

        MasterServiceState(Connection connection) {
            this.connection = connection;
        }

        public String toString() {
            return "MasterService";
        }

        Object getStub() {
            return this.stub;
        }

        void clearStub() {
            this.stub = null;
        }

        boolean isMasterRunning() throws IOException {
            MasterProtos.IsMasterRunningResponse response = null;
            try {
                response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
            catch (Exception e) {
                throw ProtobufUtil.handleRemoteException(e);
            }
            return response != null ? response.getIsMasterRunning() : false;
        }
    }
}

