/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class LongComparator
extends ByteArrayComparable {
    private long longValue;

    public LongComparator(long value) {
        super(Bytes.toBytes(value));
        this.longValue = value;
    }

    public int compareTo(byte[] value, int offset, int length) {
        long that = Bytes.toLong(value, offset, length);
        return Long.compare(this.longValue, that);
    }

    public int compareTo(ByteBuffer value, int offset, int length) {
        long that = ByteBufferUtils.toLong((ByteBuffer)value, (int)offset);
        return Long.compare(this.longValue, that);
    }

    public byte[] toByteArray() {
        ComparatorProtos.LongComparator.Builder builder = ComparatorProtos.LongComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static LongComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.LongComparator proto;
        try {
            proto = ComparatorProtos.LongComparator.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new LongComparator(Bytes.toLong(proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(LongComparator other) {
        if (other == this) {
            return true;
        }
        return super.areSerializedFieldsEqual((ByteArrayComparable)other);
    }
}

