/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.hudi.org.eclipse.jetty.client.HttpExchange;
import org.apache.hudi.org.eclipse.jetty.client.api.Response;
import org.apache.hudi.org.eclipse.jetty.util.AttributesMap;

public class HttpConversation
extends AttributesMap {
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile List<Response.ResponseListener> listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.ResponseListener overrideListener) {
        HttpExchange lastExchange;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>();
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        } else {
            listeners.addAll(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        }
        this.listeners = listeners;
    }

    public boolean abort(Throwable cause) {
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange != null && exchange.abort(cause);
    }

    @Override
    public String toString() {
        return String.format("%s[%x]", HttpConversation.class.getSimpleName(), this.hashCode());
    }
}

