/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Context;
import io.javalin.Handler;
import io.javalin.InternalServerErrorResponse;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/javalin/core/util/SwaggerRenderer;", "Lio/javalin/Handler;", "filePath", "", "(Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "swaggerVersion", "handle", "", "ctx", "Lio/javalin/Context;", "javalin"})
public final class SwaggerRenderer
implements Handler {
    private final Logger log;
    private final String swaggerVersion;
    @NotNull
    private final String filePath;

    @Override
    public void handle(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (Util.INSTANCE.getResourceUrl("META-INF/resources/webjars/swagger-ui/" + OptionalDependency.SWAGGERUI.getVersion() + "/swagger-ui.css") == null) {
            this.log.warn(Util.INSTANCE.missingDependencyMessage$javalin(OptionalDependency.SWAGGERUI));
            throw (Throwable)new InternalServerErrorResponse(Util.INSTANCE.missingDependencyMessage$javalin(OptionalDependency.SWAGGERUI));
        }
        if (Context.queryParam$default(ctx, "spec", null, 2, null) != null) {
            String string = Context.queryParam$default(ctx, "spec", null, 2, null);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            URL uRL = Util.INSTANCE.getResourceUrl(string);
            if (uRL == null) {
                Intrinsics.throwNpe();
            }
            URL uRL2 = uRL;
            Context context = ctx;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes(uRL2);
            String string2 = new String(byArray, charset);
            context.result(string2);
        } else {
            ctx.html(StringsKt.trimIndent("\n            <head>\n                <meta charset=\"UTF-8\">\n                <title>Swagger UI</title>\n                <link rel=\"icon\" type=\"image/png\" href=\"" + ctx.contextPath() + "/webjars/swagger-ui/" + this.swaggerVersion + "/favicon-16x16.png\" sizes=\"16x16\" />\n                <link rel=\"stylesheet\" href=\"" + ctx.contextPath() + "/webjars/swagger-ui/" + this.swaggerVersion + "/swagger-ui.css\" >\n                <script src=\"" + ctx.contextPath() + "/webjars/swagger-ui/" + this.swaggerVersion + "/swagger-ui-bundle.js\"></script>\n                <style>body{background:#fafafa;}</style>\n            </head>\n            <body>\n                <div id=\"swagger-ui\"></div>\n                <script>\n                    window.ui = SwaggerUIBundle({\n                        url: \"" + ctx.getMatchedPath$javalin() + "?spec=" + this.filePath + "\",\n                        dom_id: \"#swagger-ui\",\n                        deepLinking: true,\n                        presets: [SwaggerUIBundle.presets.apis],\n                    });\n                </script>\n            </body>"));
        }
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public SwaggerRenderer(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        this.filePath = filePath;
        this.log = LoggerFactory.getLogger(SwaggerRenderer.class);
        this.swaggerVersion = OptionalDependency.SWAGGERUI.getVersion();
    }
}

