/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce.wrapper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class HadoopInputSplit
extends LocatableInputSplit {
    private static final long serialVersionUID = 6119153593707857235L;
    private final Class<? extends InputSplit> splitType;
    private transient InputSplit mapreduceInputSplit;

    public HadoopInputSplit(int splitNumber, InputSplit mapreduceInputSplit, JobContext jobContext) {
        super(splitNumber, (String)null);
        if (mapreduceInputSplit == null) {
            throw new NullPointerException("Hadoop input split must not be null");
        }
        if (!(mapreduceInputSplit instanceof Writable)) {
            throw new IllegalArgumentException("InputSplit must implement Writable interface.");
        }
        this.splitType = mapreduceInputSplit.getClass();
        this.mapreduceInputSplit = mapreduceInputSplit;
    }

    public InputSplit getHadoopInputSplit() {
        return this.mapreduceInputSplit;
    }

    @Override
    public String[] getHostnames() {
        try {
            return this.mapreduceInputSplit.getLocations();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ((Writable)this.mapreduceInputSplit).write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class<Writable> writableSplit = this.splitType.asSubclass(Writable.class);
            this.mapreduceInputSplit = (InputSplit)WritableFactories.newInstance(writableSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the Hadoop InputSplit", e);
        }
        ((Writable)this.mapreduceInputSplit).readFields((DataInput)in);
    }
}

