/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBase;
import org.apache.hadoop.hbase.client.AsyncTableResultScanner;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncTableImpl
implements AsyncTable {
    private final RawAsyncTable rawTable;
    private final ExecutorService pool;
    private final long defaultScannerMaxResultSize;

    AsyncTableImpl(AsyncConnectionImpl conn, RawAsyncTable rawTable, ExecutorService pool) {
        this.rawTable = rawTable;
        this.pool = pool;
        this.defaultScannerMaxResultSize = conn.connConf.getScannerMaxResultSize();
    }

    @Override
    public TableName getName() {
        return this.rawTable.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.rawTable.getConfiguration();
    }

    @Override
    public long getRpcTimeout(TimeUnit unit) {
        return this.rawTable.getRpcTimeout(unit);
    }

    @Override
    public long getReadRpcTimeout(TimeUnit unit) {
        return this.rawTable.getReadRpcTimeout(unit);
    }

    @Override
    public long getWriteRpcTimeout(TimeUnit unit) {
        return this.rawTable.getWriteRpcTimeout(unit);
    }

    @Override
    public long getOperationTimeout(TimeUnit unit) {
        return this.rawTable.getOperationTimeout(unit);
    }

    @Override
    public long getScanTimeout(TimeUnit unit) {
        return this.rawTable.getScanTimeout(unit);
    }

    private <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        CompletableFuture asyncFuture = new CompletableFuture();
        future.whenCompleteAsync((r, e) -> {
            if (e != null) {
                asyncFuture.completeExceptionally((Throwable)e);
            } else {
                asyncFuture.complete(r);
            }
        }, (Executor)this.pool);
        return asyncFuture;
    }

    @Override
    public CompletableFuture<Result> get(Get get) {
        return this.wrap(this.rawTable.get(get));
    }

    @Override
    public CompletableFuture<Void> put(Put put) {
        return this.wrap(this.rawTable.put(put));
    }

    @Override
    public CompletableFuture<Void> delete(Delete delete) {
        return this.wrap(this.rawTable.delete(delete));
    }

    @Override
    public CompletableFuture<Result> append(Append append) {
        return this.wrap(this.rawTable.append(append));
    }

    @Override
    public CompletableFuture<Result> increment(Increment increment) {
        return this.wrap(this.rawTable.increment(increment));
    }

    @Override
    public AsyncTableBase.CheckAndMutateBuilder checkAndMutate(final byte[] row, final byte[] family) {
        return new AsyncTableBase.CheckAndMutateBuilder(){
            private final AsyncTableBase.CheckAndMutateBuilder builder;
            {
                this.builder = AsyncTableImpl.this.rawTable.checkAndMutate(row, family);
            }

            @Override
            public CompletableFuture<Boolean> thenPut(Put put) {
                return AsyncTableImpl.this.wrap(this.builder.thenPut(put));
            }

            @Override
            public CompletableFuture<Boolean> thenMutate(RowMutations mutation) {
                return AsyncTableImpl.this.wrap(this.builder.thenMutate(mutation));
            }

            @Override
            public CompletableFuture<Boolean> thenDelete(Delete delete) {
                return AsyncTableImpl.this.wrap(this.builder.thenDelete(delete));
            }

            @Override
            public AsyncTableBase.CheckAndMutateBuilder qualifier(byte[] qualifier) {
                this.builder.qualifier(qualifier);
                return this;
            }

            @Override
            public AsyncTableBase.CheckAndMutateBuilder ifNotExists() {
                this.builder.ifNotExists();
                return this;
            }

            @Override
            public AsyncTableBase.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
                this.builder.ifMatches(compareOp, value);
                return this;
            }
        };
    }

    @Override
    public CompletableFuture<Void> mutateRow(RowMutations mutation) {
        return this.wrap(this.rawTable.mutateRow(mutation));
    }

    @Override
    public CompletableFuture<List<Result>> scanAll(Scan scan) {
        return this.wrap(this.rawTable.scanAll(scan));
    }

    private long resultSize2CacheSize(long maxResultSize) {
        return maxResultSize > 0x3FFFFFFFFFFFFFFFL ? maxResultSize : maxResultSize * 2L;
    }

    @Override
    public ResultScanner getScanner(Scan scan) {
        return new AsyncTableResultScanner(this.rawTable, (Scan)ReflectionUtils.newInstance(scan.getClass(), scan), this.resultSize2CacheSize(scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : this.defaultScannerMaxResultSize));
    }

    private void scan0(Scan scan, ScanResultConsumer consumer) {
        try (ResultScanner scanner = this.getScanner(scan);){
            Result result;
            consumer.onScanMetricsCreated(scanner.getScanMetrics());
            while ((result = scanner.next()) != null && consumer.onNext(result)) {
            }
            consumer.onComplete();
        }
        catch (IOException e) {
            consumer.onError(e);
        }
    }

    @Override
    public void scan(Scan scan, ScanResultConsumer consumer) {
        this.pool.execute(() -> this.scan0(scan, consumer));
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        return this.rawTable.get(gets).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public List<CompletableFuture<Void>> put(List<Put> puts) {
        return this.rawTable.put(puts).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public List<CompletableFuture<Void>> delete(List<Delete> deletes) {
        return this.rawTable.delete(deletes).stream().map(this::wrap).collect(Collectors.toList());
    }

    @Override
    public <T> List<CompletableFuture<T>> batch(List<? extends Row> actions) {
        return this.rawTable.batch(actions).stream().map(this::wrap).collect(Collectors.toList());
    }
}

