/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.DefaultCipherProvider;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.crypto.aes.AES;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestAES {
    @Test
    public void testAESAlgorithm() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Cipher aes = Encryption.getCipher(conf, "AES");
        Assert.assertEquals((long)aes.getKeyLength(), (long)16L);
        Assert.assertEquals((long)aes.getIvLength(), (long)16L);
        Encryptor e = aes.getEncryptor();
        e.setKey(new SecretKeySpec(Bytes.fromHex("2b7e151628aed2a6abf7158809cf4f3c"), "AES"));
        e.setIv(Bytes.fromHex("f0f1f2f3f4f5f6f7f8f9fafbfcfdfeff"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream cout = e.createEncryptionStream(out);
        cout.write(Bytes.fromHex("6bc1bee22e409f96e93d7e117393172a"));
        cout.write(Bytes.fromHex("ae2d8a571e03ac9c9eb76fac45af8e51"));
        cout.write(Bytes.fromHex("30c81c46a35ce411e5fbc1191a0a52ef"));
        cout.write(Bytes.fromHex("f69f2445df4f9b17ad2b417be66c3710"));
        cout.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        byte[] b = new byte[16];
        IOUtils.readFully((InputStream)in, (byte[])b);
        Assert.assertTrue((String)"Failed #1", (boolean)Bytes.equals(b, Bytes.fromHex("874d6191b620e3261bef6864990db6ce")));
        IOUtils.readFully((InputStream)in, (byte[])b);
        Assert.assertTrue((String)"Failed #2", (boolean)Bytes.equals(b, Bytes.fromHex("9806f66b7970fdff8617187bb9fffdff")));
        IOUtils.readFully((InputStream)in, (byte[])b);
        Assert.assertTrue((String)"Failed #3", (boolean)Bytes.equals(b, Bytes.fromHex("5ae4df3edbd5d35e5b4f09020db03eab")));
        IOUtils.readFully((InputStream)in, (byte[])b);
        Assert.assertTrue((String)"Failed #4", (boolean)Bytes.equals(b, Bytes.fromHex("1e031dda2fbe03d1792170a0f3009cee")));
    }

    @Test
    public void testAlternateRNG() throws Exception {
        Security.addProvider(new TestProvider());
        Configuration conf = new Configuration();
        conf.set("hbase.crypto.algorithm.rng", "TestRNG");
        conf.set("hbase.crypto.algorithm.rng.provider", "TEST");
        DefaultCipherProvider.getInstance().setConf(conf);
        AES aes = new AES(DefaultCipherProvider.getInstance());
        Assert.assertEquals((String)"AES did not find alternate RNG", (Object)aes.getRNG().getAlgorithm(), (Object)"TestRNG");
    }

    public static class TestRNG
    extends SecureRandomSpi {
        private static final long serialVersionUID = 1L;
        private SecureRandom rng;

        public TestRNG() {
            try {
                this.rng = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                Assert.fail((String)"Unable to create SecureRandom instance");
            }
        }

        @Override
        protected void engineSetSeed(byte[] seed) {
            this.rng.setSeed(seed);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            this.rng.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return this.rng.generateSeed(numBytes);
        }
    }

    static class TestProvider
    extends Provider {
        private static final long serialVersionUID = 1L;

        public TestProvider() {
            super("TEST", 1.0, "Test provider");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    TestProvider.this.put("SecureRandom.TestRNG", TestAES.class.getName() + "$TestRNG");
                    return null;
                }
            });
        }
    }
}

