/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="Thinks zkw needs to be synchronized access but should be fine as is.")
public abstract class HBaseReplicationEndpoint
extends BaseReplicationEndpoint
implements Abortable {
    private static final Log LOG = LogFactory.getLog(HBaseReplicationEndpoint.class);
    private ZooKeeperWatcher zkw = null;
    private List<ServerName> regionServers = new ArrayList<ServerName>(0);
    private long lastRegionServerUpdate;

    protected void disconnect() {
        if (this.zkw != null) {
            this.zkw.close();
        }
    }

    protected void reconnect(KeeperException ke) {
        if (ke instanceof KeeperException.ConnectionLossException || ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.AuthFailedException) {
            String clusterKey = this.ctx.getPeerConfig().getClusterKey();
            LOG.warn((Object)("Lost the ZooKeeper connection for peer " + clusterKey), (Throwable)ke);
            try {
                this.reloadZkWatcher();
            }
            catch (IOException io) {
                LOG.warn((Object)("Creation of ZookeeperWatcher failed for peer " + clusterKey), (Throwable)io);
            }
        }
    }

    protected void doStart() {
        try {
            this.reloadZkWatcher();
            this.notifyStarted();
        }
        catch (IOException e) {
            this.notifyFailed(e);
        }
    }

    protected void doStop() {
        this.disconnect();
        this.notifyStopped();
    }

    @Override
    public synchronized UUID getPeerUUID() {
        UUID peerUUID = null;
        try {
            peerUUID = ZKClusterId.getUUIDForCluster(this.zkw);
        }
        catch (KeeperException ke) {
            this.reconnect(ke);
        }
        return peerUUID;
    }

    protected ZooKeeperWatcher getZkw() {
        return this.zkw;
    }

    void reloadZkWatcher() throws IOException {
        if (this.zkw != null) {
            this.zkw.close();
        }
        this.zkw = new ZooKeeperWatcher(this.ctx.getConfiguration(), "connection to cluster: " + this.ctx.getPeerId(), this);
        this.getZkw().registerListener(new PeerRegionServerListener(this));
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.fatal((Object)("The HBaseReplicationEndpoint corresponding to peer " + this.ctx.getPeerId() + " was aborted for the following reason(s):" + why), e);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    protected static List<ServerName> fetchSlavesAddresses(ZooKeeperWatcher zkw) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, zkw.rsZNode);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerName> addresses = new ArrayList<ServerName>(children.size());
        for (String child : children) {
            addresses.add(ServerName.parseServerName((String)child));
        }
        return addresses;
    }

    public synchronized List<ServerName> getRegionServers() {
        try {
            this.setRegionServers(HBaseReplicationEndpoint.fetchSlavesAddresses(this.getZkw()));
        }
        catch (KeeperException ke) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fetch slaves addresses failed", (Throwable)ke);
            }
            this.reconnect(ke);
        }
        return this.regionServers;
    }

    public synchronized void setRegionServers(List<ServerName> regionServers) {
        this.regionServers = regionServers;
        this.lastRegionServerUpdate = System.currentTimeMillis();
    }

    public long getLastRegionServerUpdate() {
        return this.lastRegionServerUpdate;
    }

    public static class PeerRegionServerListener
    extends ZooKeeperListener {
        private final HBaseReplicationEndpoint replicationEndpoint;
        private final String regionServerListNode;

        public PeerRegionServerListener(HBaseReplicationEndpoint replicationPeer) {
            super(replicationPeer.getZkw());
            this.replicationEndpoint = replicationPeer;
            this.regionServerListNode = this.replicationEndpoint.getZkw().rsZNode;
        }

        @Override
        public synchronized void nodeChildrenChanged(String path) {
            if (path.equals(this.regionServerListNode)) {
                try {
                    LOG.info((Object)"Detected change to peer region servers, fetching updated list");
                    this.replicationEndpoint.setRegionServers(HBaseReplicationEndpoint.fetchSlavesAddresses(this.replicationEndpoint.getZkw()));
                }
                catch (KeeperException e) {
                    LOG.fatal((Object)"Error reading slave addresses", (Throwable)e);
                }
            }
        }
    }
}

