/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hudi.com.google.protobuf.ByteString;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AccessControlUtil {
    private AccessControlUtil() {
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, TableName tableName, byte[] family, byte[] qualifier, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName == null) {
            throw new NullPointerException("TableName cannot be null");
        }
        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap(family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap(qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, String namespace, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8(namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, String namespace, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8(namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(String user, Permission perms) {
        return AccessControlProtos.UsersAndPermissions.newBuilder().addUserPermissions(AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder().setUser(ByteString.copyFromUtf8(user)).addPermissions(AccessControlUtil.toPermission(perms)).build()).build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(ListMultimap<String, Permission> perms) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry entry : perms.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8((String)entry.getKey()));
            for (Permission perm : (Collection)entry.getValue()) {
                userPermBuilder.addPermissions(AccessControlUtil.toPermission(perm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static ListMultimap<String, Permission> toUsersAndPermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (AccessControlProtos.UsersAndPermissions.UserPermissions userPerms : proto.getUserPermissionsList()) {
            String user = userPerms.getUser().toStringUtf8();
            for (AccessControlProtos.Permission perm : userPerms.getPermissionsList()) {
                result.put((Object)user, (Object)AccessControlUtil.toPermission(perm));
            }
        }
        return result;
    }

    public static Permission toPermission(AccessControlProtos.Permission proto) {
        if (proto.getType() != AccessControlProtos.Permission.Type.Global) {
            return AccessControlUtil.toTablePermission(proto);
        }
        List<Permission.Action> actions = AccessControlUtil.toPermissionActions(proto.getGlobalPermission().getActionList());
        return new Permission(actions.toArray(new Permission.Action[actions.size()]));
    }

    public static TablePermission toTablePermission(AccessControlProtos.Permission proto) {
        if (proto.getType() == AccessControlProtos.Permission.Type.Global) {
            AccessControlProtos.GlobalPermission perm = proto.getGlobalPermission();
            List<Permission.Action> actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            return new TablePermission(null, null, null, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Namespace) {
            AccessControlProtos.NamespacePermission perm = proto.getNamespacePermission();
            List<Permission.Action> actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            if (!proto.hasNamespacePermission()) {
                throw new IllegalStateException("Namespace must not be empty in NamespacePermission");
            }
            String namespace = perm.getNamespaceName().toStringUtf8();
            return new TablePermission(namespace, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Table) {
            AccessControlProtos.TablePermission perm = proto.getTablePermission();
            List<Permission.Action> actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            byte[] qualifier = null;
            byte[] family = null;
            TableName table = null;
            if (!perm.hasTableName()) {
                throw new IllegalStateException("TableName cannot be empty");
            }
            table = ProtobufUtil.toTableName(perm.getTableName());
            if (perm.hasFamily()) {
                family = perm.getFamily().toByteArray();
            }
            if (perm.hasQualifier()) {
                qualifier = perm.getQualifier().toByteArray();
            }
            return new TablePermission(table, family, qualifier, actions.toArray(new Permission.Action[actions.size()]));
        }
        throw new IllegalStateException("Unrecognize Perm Type: " + proto.getType());
    }

    public static AccessControlProtos.Permission toPermission(Permission perm) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        if (perm instanceof TablePermission) {
            TablePermission tablePerm = (TablePermission)perm;
            if (tablePerm.hasNamespace()) {
                ret.setType(AccessControlProtos.Permission.Type.Namespace);
                AccessControlProtos.NamespacePermission.Builder builder = AccessControlProtos.NamespacePermission.newBuilder();
                builder.setNamespaceName(ByteString.copyFromUtf8(tablePerm.getNamespace()));
                Permission.Action[] actions = perm.getActions();
                if (actions != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(AccessControlUtil.toPermissionAction(a));
                    }
                }
                ret.setNamespacePermission(builder);
                return ret.build();
            }
            if (tablePerm.hasTable()) {
                Permission.Action[] actions;
                ret.setType(AccessControlProtos.Permission.Type.Table);
                AccessControlProtos.TablePermission.Builder builder = AccessControlProtos.TablePermission.newBuilder();
                builder.setTableName(ProtobufUtil.toProtoTableName(tablePerm.getTableName()));
                if (tablePerm.hasFamily()) {
                    builder.setFamily(ByteStringer.wrap(tablePerm.getFamily()));
                }
                if (tablePerm.hasQualifier()) {
                    builder.setQualifier(ByteStringer.wrap(tablePerm.getQualifier()));
                }
                if ((actions = perm.getActions()) != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(AccessControlUtil.toPermissionAction(a));
                    }
                }
                ret.setTablePermission(builder);
                return ret.build();
            }
        }
        ret.setType(AccessControlProtos.Permission.Type.Global);
        AccessControlProtos.GlobalPermission.Builder builder = AccessControlProtos.GlobalPermission.newBuilder();
        Permission.Action[] actions = perm.getActions();
        if (actions != null) {
            for (Permission.Action a : actions) {
                builder.addAction(AccessControlUtil.toPermissionAction(a));
            }
        }
        ret.setGlobalPermission(builder);
        return ret.build();
    }

    public static List<Permission.Action> toPermissionActions(List<AccessControlProtos.Permission.Action> protoActions) {
        ArrayList<Permission.Action> actions = new ArrayList<Permission.Action>(protoActions.size());
        for (AccessControlProtos.Permission.Action a : protoActions) {
            actions.add(AccessControlUtil.toPermissionAction(a));
        }
        return actions;
    }

    public static Permission.Action toPermissionAction(AccessControlProtos.Permission.Action action) {
        switch (action) {
            case READ: {
                return Permission.Action.READ;
            }
            case WRITE: {
                return Permission.Action.WRITE;
            }
            case EXEC: {
                return Permission.Action.EXEC;
            }
            case CREATE: {
                return Permission.Action.CREATE;
            }
            case ADMIN: {
                return Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.Permission.Action toPermissionAction(Permission.Action action) {
        switch (action) {
            case READ: {
                return AccessControlProtos.Permission.Action.READ;
            }
            case WRITE: {
                return AccessControlProtos.Permission.Action.WRITE;
            }
            case EXEC: {
                return AccessControlProtos.Permission.Action.EXEC;
            }
            case CREATE: {
                return AccessControlProtos.Permission.Action.CREATE;
            }
            case ADMIN: {
                return AccessControlProtos.Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.UserPermission toUserPermission(UserPermission perm) {
        return AccessControlProtos.UserPermission.newBuilder().setUser(ByteStringer.wrap(perm.getUser())).setPermission(AccessControlUtil.toPermission(perm)).build();
    }

    public static AccessControlProtos.GetUserPermissionsResponse buildGetUserPermissionsResponse(List<UserPermission> permissions) {
        AccessControlProtos.GetUserPermissionsResponse.Builder builder = AccessControlProtos.GetUserPermissionsResponse.newBuilder();
        for (UserPermission perm : permissions) {
            builder.addUserPermission(AccessControlUtil.toUserPermission(perm));
        }
        return builder.build();
    }

    public static UserPermission toUserPermission(AccessControlProtos.UserPermission proto) {
        return new UserPermission(proto.getUser().toByteArray(), AccessControlUtil.toTablePermission(proto.getPermission()));
    }

    public static AccessControlProtos.UsersAndPermissions toUserTablePermissions(ListMultimap<String, TablePermission> perm) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry entry : perm.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8((String)entry.getKey()));
            for (TablePermission tablePerm : (Collection)entry.getValue()) {
                userPermBuilder.addPermissions(AccessControlUtil.toPermission(tablePerm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, tableName, f, q, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, namespace, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, tableName, f, q, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, namespace, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        builder.setType(AccessControlProtos.Permission.Type.Global);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, TableName t) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (t != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(t));
        }
        builder.setType(AccessControlProtos.Permission.Type.Table);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, byte[] namespace) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (namespace != null) {
            builder.setNamespaceName(ByteStringer.wrap(namespace));
        }
        builder.setType(AccessControlProtos.Permission.Type.Namespace);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static ListMultimap<String, TablePermission> toUserTablePermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap perms = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                TablePermission tablePerm = AccessControlUtil.toTablePermission(userPerm.getPermissions(j));
                perms.put((Object)userPerm.getUser().toStringUtf8(), (Object)tablePerm);
            }
        }
        return perms;
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, TableName tableName, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName != null) {
            permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap(family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap(qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }
}

