/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AsyncAdminRequestRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final Callable<T> callable;
    private ServerName serverName;

    public AsyncAdminRequestRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, int priority, long pauseNs, long pauseForCQTBENs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt, ServerName serverName, Callable<T> callable) {
        super(retryTimer, conn, priority, pauseNs, pauseForCQTBENs, maxAttempts, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.serverName = serverName;
        this.callable = callable;
    }

    @Override
    protected void doCall() {
        AdminProtos.AdminService.Interface adminStub;
        try {
            adminStub = this.conn.getAdminStub(this.serverName);
        }
        catch (IOException e) {
            this.onError(e, () -> "Get async admin stub to " + this.serverName + " failed", err -> {});
            return;
        }
        this.resetCallTimeout();
        FutureUtils.addListener(this.callable.call(this.controller, adminStub), (result, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Call to admin stub failed", err -> {});
                return;
            }
            this.future.complete(result);
        });
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, AdminProtos.AdminService.Interface var2);
    }
}

