/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionLoadStats;
import io.hops.hudi.org.apache.hadoop.hbase.client.StatisticTrackable;
import io.hops.hudi.org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import io.hops.hudi.org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerStatisticTracker
implements StatisticTrackable {
    private final ConcurrentHashMap<ServerName, ServerStatistics> stats = new ConcurrentHashMap();

    @Override
    public void updateRegionStats(ServerName server, byte[] region, RegionLoadStats currentStats) {
        ConcurrentMapUtils.computeIfAbsent(this.stats, server, ServerStatistics::new).update(region, currentStats);
    }

    public ServerStatistics getStats(ServerName server) {
        return this.stats.get(server);
    }

    public static ServerStatisticTracker create(Configuration conf) {
        if (!conf.getBoolean("hbase.client.backpressure.enabled", false)) {
            return null;
        }
        return new ServerStatisticTracker();
    }
}

