/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.crypto.aes;

import io.hops.hudi.org.apache.hadoop.hbase.io.crypto.Encryptor;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AESEncryptor
implements Encryptor {
    private Cipher cipher;
    private SecureRandom rng;
    private Key key;
    private byte[] iv;
    private boolean initialized = false;

    public AESEncryptor(Cipher cipher, SecureRandom rng) {
        this.cipher = cipher;
        this.rng = rng;
    }

    Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public void setIv(byte[] iv) {
        if (iv != null) {
            Preconditions.checkArgument(iv.length == 16, "Invalid IV length");
        }
        this.iv = iv;
    }

    @Override
    public OutputStream createEncryptionStream(OutputStream out) {
        if (!this.initialized) {
            this.init();
        }
        return new CipherOutputStream(out, this.cipher);
    }

    @Override
    public void reset() {
        this.init();
    }

    protected void init() {
        try {
            if (this.iv == null) {
                this.iv = new byte[this.getIvLength()];
                this.rng.nextBytes(this.iv);
            }
            this.cipher.init(1, this.key, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }
}

