/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.encoding;

import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CompressionState {
    int keyLength;
    int valueLength;
    short rowLength;
    int prevOffset = -1;
    byte familyLength;
    int qualifierLength;
    byte type;
    private static final int FIRST_KEY = -1;

    CompressionState() {
    }

    boolean isFirst() {
        return this.prevOffset == -1;
    }

    void readKey(ByteBuffer in, int keyLength, int valueLength) {
        this.readKey(in, keyLength, valueLength, 0, null);
    }

    void readKey(ByteBuffer in, int keyLength, int valueLength, int commonPrefix, CompressionState previousState) {
        this.keyLength = keyLength;
        this.valueLength = valueLength;
        in.mark();
        if (commonPrefix < 2) {
            this.rowLength = in.getShort();
            ByteBufferUtils.skip(in, this.rowLength);
            this.familyLength = in.get();
            this.qualifierLength = keyLength - this.rowLength - this.familyLength - 12;
            ByteBufferUtils.skip(in, this.familyLength + this.qualifierLength);
        } else {
            this.rowLength = previousState.rowLength;
            this.familyLength = previousState.familyLength;
            this.qualifierLength = previousState.qualifierLength + keyLength - previousState.keyLength;
            ByteBufferUtils.skip(in, 3 + this.rowLength + this.familyLength + this.qualifierLength);
        }
        this.readTimestamp(in);
        this.type = in.get();
        in.reset();
    }

    protected void readTimestamp(ByteBuffer in) {
        ByteBufferUtils.skip(in, 8);
    }

    void copyFrom(CompressionState state) {
        this.keyLength = state.keyLength;
        this.valueLength = state.valueLength;
        this.rowLength = state.rowLength;
        this.prevOffset = state.prevOffset;
        this.familyLength = state.familyLength;
        this.qualifierLength = state.qualifierLength;
        this.type = state.type;
    }
}

