/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferAllocator;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferArray;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferIOEngine
implements IOEngine {
    private ByteBufferArray bufferArray;
    private final long capacity;

    public ByteBufferIOEngine(long capacity) throws IOException {
        this.capacity = capacity;
        ByteBufferAllocator allocator = size -> ByteBuffer.allocateDirect((int)size);
        this.bufferArray = new ByteBufferArray(capacity, allocator);
    }

    public String toString() {
        return "ioengine=" + this.getClass().getSimpleName() + ", capacity=" + String.format("%,d", this.capacity);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean usesSharedMemory() {
        return true;
    }

    @Override
    public Cacheable read(BucketEntry be) throws IOException {
        ByteBuffer[] buffers = this.bufferArray.asSubByteBuffers(be.offset(), be.getLength());
        return be.wrapAsCacheable(buffers);
    }

    @Override
    public void write(ByteBuffer src, long offset) throws IOException {
        this.bufferArray.write(offset, ByteBuff.wrap(src));
    }

    @Override
    public void write(ByteBuff src, long offset) throws IOException {
        this.bufferArray.write(offset, src);
    }

    @Override
    public void sync() {
    }

    @Override
    public void shutdown() {
    }
}

