/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.ipc;

import io.hops.hudi.org.apache.hadoop.hbase.ipc.CallQueueInfo;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.CallRunner;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import io.hops.hudi.org.apache.hadoop.hbase.util.Threads;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterFifoRpcScheduler
extends FifoRpcScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MasterFifoRpcScheduler.class);
    public static final String MASTER_SERVER_REPORT_HANDLER_COUNT = "hbase.master.server.report.handler.count";
    private static final String REGION_SERVER_REPORT = "RegionServerReport";
    private final int rsReportHandlerCount;
    private final int rsRsreportMaxQueueLength;
    private final AtomicInteger rsReportQueueSize = new AtomicInteger(0);
    private ThreadPoolExecutor rsReportExecutor;

    public MasterFifoRpcScheduler(Configuration conf, int callHandlerCount, int rsReportHandlerCount) {
        super(conf, callHandlerCount);
        this.rsReportHandlerCount = rsReportHandlerCount;
        this.rsRsreportMaxQueueLength = conf.getInt("hbase.ipc.server.max.callqueue.length", rsReportHandlerCount * 10);
    }

    @Override
    public void start() {
        LOG.info("Using {} as call queue; handlerCount={}; maxQueueLength={}; rsReportHandlerCount={}; rsReportMaxQueueLength={}", new Object[]{this.getClass().getSimpleName(), this.handlerCount, this.maxQueueLength, this.rsReportHandlerCount, this.rsRsreportMaxQueueLength});
        this.executor = new ThreadPoolExecutor(this.handlerCount, this.handlerCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxQueueLength), new ThreadFactoryBuilder().setNameFormat("MasterFifoRpcScheduler.call.handler-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.rsReportExecutor = new ThreadPoolExecutor(this.rsReportHandlerCount, this.rsReportHandlerCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.rsRsreportMaxQueueLength), new ThreadFactoryBuilder().setNameFormat("MasterFifoRpcScheduler.RSReport.handler-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void stop() {
        this.executor.shutdown();
        this.rsReportExecutor.shutdown();
    }

    @Override
    public boolean dispatch(CallRunner task) throws IOException, InterruptedException {
        String method = this.getCallMethod(task);
        if (this.rsReportExecutor != null && method != null && method.equals(REGION_SERVER_REPORT)) {
            return this.executeRpcCall(this.rsReportExecutor, this.rsReportQueueSize, task);
        }
        return this.executeRpcCall(this.executor, this.queueSize, task);
    }

    @Override
    public int getGeneralQueueLength() {
        return this.executor.getQueue().size() + this.rsReportExecutor.getQueue().size();
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.executor.getActiveCount() + this.rsReportExecutor.getActiveCount();
    }

    @Override
    public CallQueueInfo getCallQueueInfo() {
        String queueName = "Master Fifo Queue";
        HashMap<String, Long> methodCount = new HashMap<String, Long>();
        HashMap<String, Long> methodSize = new HashMap<String, Long>();
        CallQueueInfo callQueueInfo = new CallQueueInfo();
        callQueueInfo.setCallMethodCount(queueName, methodCount);
        callQueueInfo.setCallMethodSize(queueName, methodSize);
        this.updateMethodCountAndSizeByQueue(this.executor.getQueue(), methodCount, methodSize);
        this.updateMethodCountAndSizeByQueue(this.rsReportExecutor.getQueue(), methodCount, methodSize);
        return callQueueInfo;
    }
}

