/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.client.VersionInfoUtil;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class ProcedurePrepareLatch {
    private static final NoopLatch noopLatch = new NoopLatch();

    public static ProcedurePrepareLatch createLatch() {
        return ProcedurePrepareLatch.createLatch(1, 1);
    }

    public static ProcedurePrepareLatch createLatch(int major, int minor) {
        return ProcedurePrepareLatch.hasProcedureSupport(major, minor) ? noopLatch : new CompatibilityLatch();
    }

    public static ProcedurePrepareLatch createBlockingLatch() {
        return new CompatibilityLatch();
    }

    public static ProcedurePrepareLatch getNoopLatch() {
        return noopLatch;
    }

    private static boolean hasProcedureSupport(int major, int minor) {
        return VersionInfoUtil.currentClientHasMinimumVersion(major, minor);
    }

    protected abstract void countDown(Procedure var1);

    public abstract void await() throws IOException;

    public static void releaseLatch(ProcedurePrepareLatch latch, Procedure proc) {
        if (latch != null) {
            latch.countDown(proc);
        }
    }

    protected static class CompatibilityLatch
    extends ProcedurePrepareLatch {
        private final CountDownLatch latch = new CountDownLatch(1);
        private IOException exception = null;

        protected CompatibilityLatch() {
        }

        @Override
        protected void countDown(Procedure proc) {
            if (proc.hasException()) {
                this.exception = MasterProcedureUtil.unwrapRemoteIOException(proc);
            }
            this.latch.countDown();
        }

        @Override
        public void await() throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private static class NoopLatch
    extends ProcedurePrepareLatch {
        private NoopLatch() {
        }

        @Override
        protected void countDown(Procedure proc) {
        }

        @Override
        public void await() throws IOException {
        }
    }
}

