/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import io.hops.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CSLMImmutableSegment
extends ImmutableSegment {
    public static final long DEEP_OVERHEAD_CSLM = ImmutableSegment.DEEP_OVERHEAD + (long)ClassSize.CONCURRENT_SKIPLISTMAP;

    protected CSLMImmutableSegment(Segment segment, MemStoreSizing memstoreSizing) {
        super(segment);
        long indexOverhead = -MutableSegment.DEEP_OVERHEAD + DEEP_OVERHEAD_CSLM;
        this.incMemStoreSize(0L, indexOverhead, 0L, 0);
        if (memstoreSizing != null) {
            memstoreSizing.incMemStoreSize(0L, indexOverhead, 0L, 0);
        }
    }

    @Override
    protected long indexEntrySize() {
        return ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY;
    }

    @Override
    protected boolean canBeFlattened() {
        return true;
    }
}

