/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CompactionProgress {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionProgress.class);
    private long totalCompactingKVs;
    public long currentCompactedKVs = 0L;
    public long totalCompactedSize = 0L;

    public CompactionProgress(long totalCompactingKVs) {
        this.totalCompactingKVs = totalCompactingKVs;
    }

    public float getProgressPct() {
        return (float)this.currentCompactedKVs / (float)this.getTotalCompactingKVs();
    }

    public void cancel() {
        this.totalCompactingKVs = 0L;
        this.currentCompactedKVs = 0L;
    }

    public void complete() {
        this.totalCompactingKVs = this.currentCompactedKVs;
    }

    public long getTotalCompactingKVs() {
        if (this.totalCompactingKVs < this.currentCompactedKVs) {
            LOG.debug("totalCompactingKVs={} less than currentCompactedKVs={}", (Object)this.totalCompactingKVs, (Object)this.currentCompactedKVs);
            return this.currentCompactedKVs;
        }
        return this.totalCompactingKVs;
    }

    public long getCurrentCompactedKvs() {
        return this.currentCompactedKVs;
    }

    public long getTotalCompactedSize() {
        return this.totalCompactedSize;
    }

    public String toString() {
        return String.format("%d/%d (%.2f%%)", this.currentCompactedKVs, this.getTotalCompactingKVs(), Float.valueOf(100.0f * this.getProgressPct()));
    }
}

