/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.replication.WALCellFilter;
import io.hops.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class ChainWALEntryFilter
implements WALEntryFilter {
    private final WALEntryFilter[] filters;
    private WALCellFilter[] cellFilters;

    public ChainWALEntryFilter(WALEntryFilter ... filters) {
        this.filters = filters;
        this.initCellFilters();
    }

    public ChainWALEntryFilter(List<WALEntryFilter> filters) {
        ArrayList<WALEntryFilter> rawFilters = new ArrayList<WALEntryFilter>(filters.size());
        for (WALEntryFilter filter : filters) {
            if (filter instanceof ChainWALEntryFilter) {
                Collections.addAll(rawFilters, ((ChainWALEntryFilter)filter).filters);
                continue;
            }
            rawFilters.add(filter);
        }
        this.filters = rawFilters.toArray(new WALEntryFilter[rawFilters.size()]);
        this.initCellFilters();
    }

    public void initCellFilters() {
        ArrayList<WALCellFilter> cellFilters = new ArrayList<WALCellFilter>(this.filters.length);
        for (WALEntryFilter filter : this.filters) {
            if (!(filter instanceof WALCellFilter)) continue;
            cellFilters.add((WALCellFilter)((Object)filter));
        }
        this.cellFilters = cellFilters.toArray(new WALCellFilter[cellFilters.size()]);
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        for (WALEntryFilter filter : this.filters) {
            if (entry == null) {
                return null;
            }
            entry = filter.filter(entry);
        }
        this.filterCells(entry);
        return entry;
    }

    private void filterCells(WAL.Entry entry) {
        if (entry == null || this.cellFilters.length == 0) {
            return;
        }
        ArrayList<Cell> cells = entry.getEdit().getCells();
        int size = cells.size();
        block0: for (int i = size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            for (WALCellFilter filter : this.cellFilters) {
                if ((cell = filter.filterCell(entry, cell)) == null) {
                    cells.remove(i);
                    continue block0;
                }
                cells.set(i, cell);
            }
        }
        if (cells.size() < size / 2) {
            cells.trimToSize();
        }
    }
}

