/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.access;

import io.hops.hudi.org.apache.hadoop.hbase.AuthUtil;
import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import io.hops.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.security.AccessDeniedException;
import io.hops.hudi.org.apache.hadoop.hbase.security.Superusers;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.security.UserProvider;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.AuthManager;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.AuthResult;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.NamespacePermission;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.Permission;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.TablePermission;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class AccessChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AccessChecker.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + AccessChecker.class.getName()));
    private final AuthManager authManager;
    private static Groups groupService;

    public static boolean isAuthorizationSupported(Configuration conf) {
        return conf.getBoolean("hbase.security.authorization", false);
    }

    public AccessChecker(Configuration conf) {
        this.authManager = new AuthManager(conf);
        this.initGroupService(conf);
    }

    public AuthManager getAuthManager() {
        return this.authManager;
    }

    public void requireAccess(User user, String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.accessUserTable(user, tableName, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, null, null);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, String filterUser, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(user, request, perm, null, null, filterUser);
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, String filterUser) throws IOException {
        AuthResult result = this.authManager.authorizeUserGlobal(user, perm) ? AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap) : AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap);
        result.getParams().setTableName(tableName).setFamilies(familyMap);
        result.getParams().addExtraParam("filterUser", filterUser);
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
    }

    public void requireGlobalPermission(User user, String request, Permission.Action perm, String namespace) throws IOException {
        if (!this.authManager.authorizeUserGlobal(user, perm)) {
            AuthResult authResult = AuthResult.deny(request, "Global check failed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            AccessChecker.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        AuthResult authResult = AuthResult.allow(request, "Global check allowed", user, perm, null);
        authResult.getParams().setNamespace(namespace);
        AccessChecker.logResult(authResult);
    }

    public void requireNamespacePermission(User user, String request, String namespace, String filterUser, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorizeUserNamespace(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
        }
        result.getParams().addExtraParam("filterUser", filterUser);
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireNamespacePermission(User user, String request, String namespace, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorizeUserNamespace(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                result.getParams().setTableName(tableName).setFamilies(familyMap);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requirePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, String filterUser, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorizeUserTable(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        result.getParams().addExtraParam("filterUser", filterUser);
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireTablePermission(User user, String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorizeUserTable(user, tableName, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                result.getParams().setFamily(family).setQualifier(qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
            result.getParams().setFamily(family).setQualifier(qualifier);
        }
        AccessChecker.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void performOnSuperuser(String request, User caller, String userToBeChecked) throws IOException {
        ArrayList<String> userGroups = new ArrayList<String>();
        userGroups.add(userToBeChecked);
        if (!AuthUtil.isGroupPrincipal(userToBeChecked)) {
            for (String group : AccessChecker.getUserGroups(userToBeChecked)) {
                userGroups.add(AuthUtil.toGroupEntry(group));
            }
        }
        for (String name : userGroups) {
            if (!Superusers.isSuperUser(name)) continue;
            AuthResult result = AuthResult.deny(request, "Granting or revoking superusers's or supergroups's permissions is not allowed", caller, Permission.Action.ADMIN, NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
            AccessChecker.logResult(result);
            throw new AccessDeniedException(result.getReason());
        }
    }

    public void checkLockPermissions(User user, String namespace, TableName tableName, RegionInfo[] regionInfos, String reason) throws IOException {
        if (namespace != null && !namespace.isEmpty()) {
            this.requireNamespacePermission(user, reason, namespace, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        } else if (tableName != null || regionInfos != null && regionInfos.length > 0) {
            TableName tn = tableName != null ? tableName : regionInfos[0].getTable();
            this.requireTablePermission(user, reason, tn, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        } else {
            throw new DoNotRetryIOException("Invalid lock level when requesting permissions.");
        }
    }

    public static void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            User user = result.getUser();
            UserGroupInformation ugi = user != null ? user.getUGI() : null;
            AUDITLOG.trace("Access {} for user {}; reason: {}; remote address: {}; request: {}; context: {};auth method: {}", new Object[]{result.isAllowed() ? "allowed" : "denied", user != null ? user.getShortName() : "UNKNOWN", result.getReason(), RpcServer.getRemoteAddress().map(InetAddress::toString).orElse(""), result.getRequest(), result.toContextString(), ugi != null ? ugi.getAuthenticationMethod() : "UNKNOWN"});
        }
    }

    public User validateCallerWithFilterUser(User caller, TablePermission tPerm, String inputUserName) throws IOException {
        User filterUser = null;
        if (!caller.getShortName().equals(inputUserName)) {
            this.requirePermission(caller, "hasPermission", tPerm.getTableName(), tPerm.getFamily(), tPerm.getQualifier(), inputUserName, Permission.Action.ADMIN);
            List<String> groups2 = AccessChecker.getUserGroups(inputUserName);
            filterUser = new InputUser(inputUserName, groups2.toArray(new String[groups2.size()]));
        } else {
            AuthResult result = AuthResult.allow("hasPermission", "Self user validation allowed", caller, null, tPerm.getTableName(), tPerm.getFamily(), tPerm.getQualifier());
            AccessChecker.logResult(result);
            filterUser = caller;
        }
        return filterUser;
    }

    private void initGroupService(Configuration conf) {
        if (groupService == null) {
            if (conf.getBoolean("hbase.group.service.for.test.only", false)) {
                UserProvider.setGroups(new User.TestingGroups(UserProvider.getGroups()));
                groupService = UserProvider.getGroups();
            } else {
                groupService = Groups.getUserToGroupsMappingService((Configuration)conf);
            }
        }
    }

    public static List<String> getUserGroups(String user) {
        try {
            return groupService.getGroups(user);
        }
        catch (IOException e) {
            LOG.error("Error occurred while retrieving group for " + user, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public boolean hasUserPermission(User user, String request, Permission permission) {
        if (permission instanceof TablePermission) {
            TablePermission tPerm = (TablePermission)permission;
            for (Permission.Action action : permission.getActions()) {
                AuthResult authResult = this.permissionGranted(request, user, action, tPerm.getTableName(), tPerm.getFamily(), tPerm.getQualifier());
                AccessChecker.logResult(authResult);
                if (authResult.isAllowed()) continue;
                return false;
            }
        } else if (permission instanceof NamespacePermission) {
            NamespacePermission nsPerm = (NamespacePermission)permission;
            for (Permission.Action action : nsPerm.getActions()) {
                AuthResult authResult = this.getAuthManager().authorizeUserNamespace(user, nsPerm.getNamespace(), action) ? AuthResult.allow(request, "Namespace action allowed", user, action, null, null) : AuthResult.deny(request, "Namespace action denied", user, action, null, null);
                AccessChecker.logResult(authResult);
                if (authResult.isAllowed()) continue;
                return false;
            }
        } else {
            for (Permission.Action action : permission.getActions()) {
                AuthResult authResult = this.getAuthManager().authorizeUserGlobal(user, action) ? AuthResult.allow(request, "Global action allowed", user, action, null, null) : AuthResult.deny(request, "Global action denied", user, action, null, null);
                AccessChecker.logResult(authResult);
                if (authResult.isAllowed()) continue;
                return false;
            }
        }
        return true;
    }

    private AuthResult permissionGranted(String request, User user, Permission.Action permRequest, TableName tableName, byte[] family, byte[] qualifier) {
        Map<byte[], ? extends Collection<byte[]>> map = this.makeFamilyMap(family, qualifier);
        return this.permissionGranted(request, user, permRequest, tableName, map);
    }

    public AuthResult permissionGranted(String request, User user, Permission.Action permRequest, TableName tableName, Map<byte[], ? extends Collection<?>> families) {
        if (TableName.META_TABLE_NAME.equals(tableName) && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (this.getAuthManager().authorizeUserTable(user, tableName, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.getAuthManager().authorizeUserTable(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.getAuthManager().authorizeUserTable(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List cellList = (List)family.getValue();
                    for (Cell cell : cellList) {
                        if (this.getAuthManager().authorizeUserTable(user, tableName, family.getKey(), CellUtil.cloneQualifier(cell), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), CellUtil.cloneQualifier(cell)));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap<byte[], ImmutableSet<byte[]>> familyMap = new TreeMap<byte[], ImmutableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of(qualifier) : null);
        return familyMap;
    }

    public static class InputUser
    extends User {
        private String name;
        private String shortName = null;
        private String[] groups;

        public InputUser(String name, String[] groups2) {
            this.name = name;
            this.groups = groups2;
        }

        @Override
        public String getShortName() {
            if (this.shortName == null) {
                try {
                    this.shortName = new HadoopKerberosName(this.name).getShortName();
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Illegal principal name " + this.name + ": " + ioe.toString(), ioe);
                }
            }
            return this.shortName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getGroupNames() {
            return this.groups;
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            throw new UnsupportedOperationException("Method not supported, this class has limited implementation");
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Method not supported, this class has limited implementation");
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

