/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.access;

import io.hops.hudi.com.google.protobuf.ByteString;
import io.hops.hudi.com.google.protobuf.RpcController;
import io.hops.hudi.com.google.protobuf.ServiceException;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.NamespacePermission;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.Permission;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.TablePermission;
import io.hops.hudi.org.apache.hadoop.hbase.security.access.UserPermission;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteStringer;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AccessControlUtil {
    private AccessControlUtil() {
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, TableName tableName, byte[] family, byte[] qualifier, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName == null) {
            throw new NullPointerException("TableName cannot be null");
        }
        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap(family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap(qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, String namespace, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8(namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, String namespace, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8(namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, boolean mergeExistingPermissions, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).setMergeExistingPermissions(mergeExistingPermissions).build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(String user, Permission perms) {
        return AccessControlProtos.UsersAndPermissions.newBuilder().addUserPermissions(AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder().setUser(ByteString.copyFromUtf8(user)).addPermissions(AccessControlUtil.toPermission(perms)).build()).build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(ListMultimap<String, Permission> perms) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry<String, Collection<Permission>> entry : perms.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8(entry.getKey()));
            for (Permission perm : entry.getValue()) {
                userPermBuilder.addPermissions(AccessControlUtil.toPermission(perm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static ListMultimap<String, Permission> toUsersAndPermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap<String, Permission> result = ArrayListMultimap.create();
        for (AccessControlProtos.UsersAndPermissions.UserPermissions userPerms : proto.getUserPermissionsList()) {
            String user = userPerms.getUser().toStringUtf8();
            for (AccessControlProtos.Permission perm : userPerms.getPermissionsList()) {
                result.put(user, AccessControlUtil.toPermission(perm));
            }
        }
        return result;
    }

    public static TablePermission toTablePermission(AccessControlProtos.TablePermission proto) {
        Permission.Action[] actions = AccessControlUtil.toPermissionActions(proto.getActionList());
        TableName table = null;
        byte[] qualifier = null;
        byte[] family = null;
        if (!proto.hasTableName()) {
            throw new IllegalStateException("TableName cannot be empty");
        }
        table = ProtobufUtil.toTableName(proto.getTableName());
        if (proto.hasFamily()) {
            family = proto.getFamily().toByteArray();
        }
        if (proto.hasQualifier()) {
            qualifier = proto.getQualifier().toByteArray();
        }
        return new TablePermission(table, family, qualifier, actions);
    }

    public static Permission toPermission(AccessControlProtos.Permission proto) {
        if (proto.getType() == AccessControlProtos.Permission.Type.Global) {
            AccessControlProtos.GlobalPermission perm = proto.getGlobalPermission();
            Permission.Action[] actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            return Permission.newBuilder().withActions(actions).build();
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Namespace) {
            AccessControlProtos.NamespacePermission perm = proto.getNamespacePermission();
            Permission.Action[] actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            if (!proto.hasNamespacePermission()) {
                throw new IllegalStateException("Namespace must not be empty in NamespacePermission");
            }
            return Permission.newBuilder(perm.getNamespaceName().toStringUtf8()).withActions(actions).build();
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Table) {
            AccessControlProtos.TablePermission perm = proto.getTablePermission();
            Permission.Action[] actions = AccessControlUtil.toPermissionActions(perm.getActionList());
            byte[] qualifier = null;
            byte[] family = null;
            TableName table = null;
            if (!perm.hasTableName()) {
                throw new IllegalStateException("TableName cannot be empty");
            }
            table = ProtobufUtil.toTableName(perm.getTableName());
            if (perm.hasFamily()) {
                family = perm.getFamily().toByteArray();
            }
            if (perm.hasQualifier()) {
                qualifier = perm.getQualifier().toByteArray();
            }
            return Permission.newBuilder(table).withFamily(family).withQualifier(qualifier).withActions(actions).build();
        }
        throw new IllegalStateException("Unrecognize Perm Type: " + proto.getType());
    }

    public static AccessControlProtos.Permission toPermission(Permission perm) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        if (perm instanceof NamespacePermission) {
            NamespacePermission namespace = (NamespacePermission)perm;
            ret.setType(AccessControlProtos.Permission.Type.Namespace);
            AccessControlProtos.NamespacePermission.Builder builder = AccessControlProtos.NamespacePermission.newBuilder();
            builder.setNamespaceName(ByteString.copyFromUtf8(namespace.getNamespace()));
            Permission.Action[] actions = perm.getActions();
            if (actions != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(AccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setNamespacePermission(builder);
        } else if (perm instanceof TablePermission) {
            Permission.Action[] actions;
            TablePermission table = (TablePermission)perm;
            ret.setType(AccessControlProtos.Permission.Type.Table);
            AccessControlProtos.TablePermission.Builder builder = AccessControlProtos.TablePermission.newBuilder();
            builder.setTableName(ProtobufUtil.toProtoTableName(table.getTableName()));
            if (table.hasFamily()) {
                builder.setFamily(ByteStringer.wrap(table.getFamily()));
            }
            if (table.hasQualifier()) {
                builder.setQualifier(ByteStringer.wrap(table.getQualifier()));
            }
            if ((actions = perm.getActions()) != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(AccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setTablePermission(builder);
        } else {
            ret.setType(AccessControlProtos.Permission.Type.Global);
            AccessControlProtos.GlobalPermission.Builder builder = AccessControlProtos.GlobalPermission.newBuilder();
            Permission.Action[] actions = perm.getActions();
            if (actions != null) {
                for (Permission.Action a : actions) {
                    builder.addAction(AccessControlUtil.toPermissionAction(a));
                }
            }
            ret.setGlobalPermission(builder);
        }
        return ret.build();
    }

    public static Permission.Action[] toPermissionActions(List<AccessControlProtos.Permission.Action> protoActions) {
        Permission.Action[] actions = new Permission.Action[protoActions.size()];
        for (int i = 0; i < protoActions.size(); ++i) {
            actions[i] = AccessControlUtil.toPermissionAction(protoActions.get(i));
        }
        return actions;
    }

    public static Permission.Action toPermissionAction(AccessControlProtos.Permission.Action action) {
        switch (action) {
            case READ: {
                return Permission.Action.READ;
            }
            case WRITE: {
                return Permission.Action.WRITE;
            }
            case EXEC: {
                return Permission.Action.EXEC;
            }
            case CREATE: {
                return Permission.Action.CREATE;
            }
            case ADMIN: {
                return Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.Permission.Action toPermissionAction(Permission.Action action) {
        switch (action) {
            case READ: {
                return AccessControlProtos.Permission.Action.READ;
            }
            case WRITE: {
                return AccessControlProtos.Permission.Action.WRITE;
            }
            case EXEC: {
                return AccessControlProtos.Permission.Action.EXEC;
            }
            case CREATE: {
                return AccessControlProtos.Permission.Action.CREATE;
            }
            case ADMIN: {
                return AccessControlProtos.Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.UserPermission toUserPermission(UserPermission perm) {
        return AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(perm.getUser())).setPermission(AccessControlUtil.toPermission(perm.getPermission())).build();
    }

    public static AccessControlProtos.GetUserPermissionsResponse buildGetUserPermissionsResponse(List<UserPermission> permissions) {
        AccessControlProtos.GetUserPermissionsResponse.Builder builder = AccessControlProtos.GetUserPermissionsResponse.newBuilder();
        for (UserPermission perm : permissions) {
            builder.addUserPermission(AccessControlUtil.toUserPermission(perm));
        }
        return builder.build();
    }

    public static UserPermission toUserPermission(AccessControlProtos.UserPermission proto) {
        return new UserPermission(proto.getUser().toStringUtf8(), AccessControlUtil.toPermission(proto.getPermission()));
    }

    public static AccessControlProtos.UsersAndPermissions toUserTablePermissions(ListMultimap<String, UserPermission> perm) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry<String, Collection<UserPermission>> entry : perm.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8(entry.getKey()));
            for (UserPermission userPerm : entry.getValue()) {
                userPermBuilder.addPermissions(AccessControlUtil.toPermission(userPerm.getPermission()));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    @Deprecated
    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    @Deprecated
    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, tableName, f, q, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    @Deprecated
    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, boolean mergeExistingPermissions, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = AccessControlUtil.buildGrantRequest(userShortName, namespace, mergeExistingPermissions, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    @Deprecated
    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    @Deprecated
    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, tableName, f, q, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    @Deprecated
    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, Permission.Action ... actions) throws ServiceException {
        ArrayList<AccessControlProtos.Permission.Action> permActions = Lists.newArrayListWithCapacity(actions.length);
        for (Permission.Action a : actions) {
            permActions.add(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = AccessControlUtil.buildRevokeRequest(userShortName, namespace, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol) throws ServiceException {
        return AccessControlUtil.getUserPermissions(controller, protocol, "");
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userName) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        builder.setType(AccessControlProtos.Permission.Type.Global);
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            builder.setUserName(ByteString.copyFromUtf8(userName));
        }
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, TableName t) throws ServiceException {
        return AccessControlUtil.getUserPermissions(controller, protocol, t, null, null, "");
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, TableName t, byte[] columnFamily, byte[] columnQualifier, String userName) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (t != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(t));
        }
        if (Bytes.len(columnFamily) > 0) {
            builder.setColumnFamily(ByteString.copyFrom(columnFamily));
        }
        if (Bytes.len(columnQualifier) > 0) {
            builder.setColumnQualifier(ByteString.copyFrom(columnQualifier));
        }
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            builder.setUserName(ByteString.copyFromUtf8(userName));
        }
        builder.setType(AccessControlProtos.Permission.Type.Table);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, byte[] namespace) throws ServiceException {
        return AccessControlUtil.getUserPermissions(controller, protocol, namespace, "");
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, byte[] namespace, String userName) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (namespace != null) {
            builder.setNamespaceName(ByteStringer.wrap(namespace));
        }
        if (!StringUtils.isEmpty((CharSequence)userName)) {
            builder.setUserName(ByteString.copyFromUtf8(userName));
        }
        builder.setType(AccessControlProtos.Permission.Type.Namespace);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(AccessControlUtil.toUserPermission(perm));
        }
        return perms;
    }

    @Deprecated
    public static boolean hasPermission(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, TableName tableName, byte[] columnFamily, byte[] columnQualifier, String userName, Permission.Action[] actions) throws ServiceException {
        AccessControlProtos.TablePermission.Builder tablePermissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        tablePermissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        if (Bytes.len(columnFamily) > 0) {
            tablePermissionBuilder.setFamily(ByteStringer.wrap(columnFamily));
        }
        if (Bytes.len(columnQualifier) > 0) {
            tablePermissionBuilder.setQualifier(ByteString.copyFrom(columnQualifier));
        }
        for (Permission.Action a : actions) {
            tablePermissionBuilder.addAction(AccessControlUtil.toPermissionAction(a));
        }
        AccessControlProtos.HasPermissionRequest request = AccessControlProtos.HasPermissionRequest.newBuilder().setTablePermission(tablePermissionBuilder).setUserName(ByteString.copyFromUtf8(userName)).build();
        AccessControlProtos.HasPermissionResponse response = protocol.hasPermission(controller, request);
        return response.getHasPermission();
    }

    public static ListMultimap<String, UserPermission> toUserPermission(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap<String, UserPermission> userPermission = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            String username = userPerm.getUser().toStringUtf8();
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                userPermission.put(username, new UserPermission(username, AccessControlUtil.toPermission(userPerm.getPermissions(j))));
            }
        }
        return userPermission;
    }

    public static ListMultimap<String, Permission> toPermission(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap<String, Permission> perms = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            String username = userPerm.getUser().toStringUtf8();
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                perms.put(username, AccessControlUtil.toPermission(userPerm.getPermissions(j)));
            }
        }
        return perms;
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, TableName tableName, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName != null) {
            permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap(family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap(qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8(username)).setPermission(ret)).build();
    }
}

