/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.tmpl.tool;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.tmpl.tool.CanaryStatusTmpl;
import io.hops.hudi.org.apache.hadoop.hbase.tool.CanaryTool;
import io.hops.hudi.org.apache.hadoop.hbase.util.JvmVersion;
import io.hops.hudi.org.apache.hadoop.hbase.util.VersionInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class CanaryStatusTmplImpl
extends AbstractTemplateImpl
implements CanaryStatusTmpl.Intf {
    private final CanaryTool.RegionStdOutSink sink;

    protected static CanaryStatusTmpl.ImplData __jamon_setOptionalArguments(CanaryStatusTmpl.ImplData p_implData) {
        return p_implData;
    }

    public CanaryStatusTmplImpl(TemplateManager p_templateManager, CanaryStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)CanaryStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.sink = p_implData.getSink();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Canary</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/canary-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n        </div>\n    </div>\n\n  <div class=\"container\">\n    <section>\n    <h2>Failed Servers</h2>\n        ");
        ConcurrentMap<ServerName, LongAdder> perServerFailuresCount = this.sink.getPerServerFailuresCount();
        jamonWriter.write("<table class=\"table table-striped\">\n          <tr>\n              <th>Server</th>\n              <th>Failures Count</th>\n          </tr>\n          ");
        if (perServerFailuresCount != null && perServerFailuresCount.size() > 0) {
            jamonWriter.write("\n          ");
            for (Map.Entry entry : perServerFailuresCount.entrySet()) {
                jamonWriter.write("\n          <tr>\n              <td>");
                this.__jamon_innerUnit__serverNameLink(jamonWriter, (ServerName)entry.getKey());
                jamonWriter.write("</td>\n              <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(entry.getValue()), jamonWriter);
                jamonWriter.write("</td>\n          </tr>\n          ");
            }
            jamonWriter.write("\n          ");
        }
        jamonWriter.write("\n          <tr><td>Total Failed Servers: ");
        Escaping.HTML.write(StandardEmitter.valueOf((int)(perServerFailuresCount != null ? perServerFailuresCount.size() : 0)), jamonWriter);
        jamonWriter.write("</td></tr>\n        </table>\n    </section>\n    <section>\n      <h2>Failed Tables</h2>\n            ");
        ConcurrentMap<String, LongAdder> perTableFailuresCount = this.sink.getPerTableFailuresCount();
        jamonWriter.write("<table class=\"table table-striped\">\n              <tr>\n                  <th>Table</th>\n                  <th>Failures Count</th>\n              </tr>\n              ");
        if (perTableFailuresCount != null && perTableFailuresCount.size() > 0) {
            jamonWriter.write("\n              ");
            for (Map.Entry entry : perTableFailuresCount.entrySet()) {
                jamonWriter.write("\n              <tr>\n                  <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)entry.getKey())), jamonWriter);
                jamonWriter.write("</td>\n                  <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(entry.getValue()), jamonWriter);
                jamonWriter.write("</td>\n              </tr>\n              ");
            }
            jamonWriter.write("\n              ");
        }
        jamonWriter.write("\n              <tr><td>Total Failed Tables: ");
        Escaping.HTML.write(StandardEmitter.valueOf((int)(perTableFailuresCount != null ? perTableFailuresCount.size() : 0)), jamonWriter);
        jamonWriter.write("</td></tr>\n            </table>\n    </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>JVM Version</td>\n                    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)JvmVersion.getVersion()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>JVM vendor and version</td>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", r");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
    }

    private void __jamon_innerUnit__serverNameLink(Writer jamonWriter, ServerName serverName) throws IOException {
        int infoPort = serverName.getPort() + 1;
        String url2 = "//" + serverName.getHostname() + ":" + infoPort + "/";
        if (infoPort > 0) {
            jamonWriter.write("\n            <a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf((String)url2), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getServerName()), jamonWriter);
            jamonWriter.write("</a>\n        ");
        } else {
            jamonWriter.write("\n            ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)serverName.getServerName()), jamonWriter);
            jamonWriter.write("\n        ");
        }
        jamonWriter.write("\n");
    }
}

