/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.hops.hudi.org.apache.hadoop.hbase.HConstants;
import io.hops.hudi.org.apache.hadoop.hbase.TableDescriptors;
import io.hops.hudi.org.apache.hadoop.hbase.TableInfoMissingException;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.FSUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FSTableDescriptors
implements TableDescriptors {
    private static final Logger LOG = LoggerFactory.getLogger(FSTableDescriptors.class);
    private final FileSystem fs;
    private final Path rootdir;
    private final boolean fsreadonly;
    private final boolean usecache;
    private volatile boolean fsvisited;
    long cachehits = 0L;
    long invocations = 0L;
    static final String TABLEINFO_FILE_PREFIX = ".tableinfo";
    static final String TABLEINFO_DIR = ".tabledesc";
    static final String TMP_DIR = ".tmp";
    private final Map<TableName, TableDescriptor> cache = new ConcurrentHashMap<TableName, TableDescriptor>();
    static final Comparator<FileStatus> TABLEINFO_FILESTATUS_COMPARATOR = new Comparator<FileStatus>(){

        @Override
        public int compare(FileStatus left, FileStatus right) {
            return right.compareTo(left);
        }
    };
    private static final PathFilter TABLEINFO_PATHFILTER = new PathFilter(){

        public boolean accept(Path p) {
            return p.getName().startsWith(FSTableDescriptors.TABLEINFO_FILE_PREFIX);
        }
    };
    static final int WIDTH_OF_SEQUENCE_ID = 10;
    private static final Pattern TABLEINFO_FILE_REGEX = Pattern.compile(".tableinfo(\\.([0-9]{10}))?$");

    public FSTableDescriptors(Configuration conf) throws IOException {
        this(CommonFSUtils.getCurrentFileSystem(conf), CommonFSUtils.getRootDir(conf));
    }

    public FSTableDescriptors(FileSystem fs, Path rootdir) {
        this(fs, rootdir, false, true);
    }

    public FSTableDescriptors(FileSystem fs, Path rootdir, boolean fsreadonly, boolean usecache) {
        this.fs = fs;
        this.rootdir = rootdir;
        this.fsreadonly = fsreadonly;
        this.usecache = usecache;
    }

    public static void tryUpdateMetaTableDescriptor(Configuration conf) throws IOException {
        FSTableDescriptors.tryUpdateAndGetMetaTableDescriptor(conf, CommonFSUtils.getCurrentFileSystem(conf), CommonFSUtils.getRootDir(conf));
    }

    public static TableDescriptor tryUpdateAndGetMetaTableDescriptor(Configuration conf, FileSystem fs, Path rootdir) throws IOException {
        try {
            return FSTableDescriptors.getTableDescriptorFromFs(fs, rootdir, TableName.META_TABLE_NAME);
        }
        catch (TableInfoMissingException e) {
            TableDescriptorBuilder builder = FSTableDescriptors.createMetaTableDescriptorBuilder(conf);
            TableDescriptor td = builder.build();
            LOG.info("Creating new hbase:meta table descriptor {}", (Object)td);
            TableName tableName = td.getTableName();
            Path tableDir = CommonFSUtils.getTableDir(rootdir, tableName);
            Path p = FSTableDescriptors.writeTableDescriptor(fs, td, tableDir, FSTableDescriptors.getTableInfoPath(fs, tableDir, true));
            if (p == null) {
                throw new IOException("Failed update hbase:meta table descriptor");
            }
            LOG.info("Updated hbase:meta table descriptor to {}", (Object)p);
            return td;
        }
    }

    public static ColumnFamilyDescriptor getTableFamilyDescForMeta(Configuration conf) {
        return ColumnFamilyDescriptorBuilder.newBuilder(HConstants.TABLE_FAMILY).setMaxVersions(conf.getInt("hbase.meta.versions", 3)).setInMemory(true).setBlocksize(8192).setScope(0).setBloomFilterType(BloomType.NONE).build();
    }

    public static ColumnFamilyDescriptor getReplBarrierFamilyDescForMeta() {
        return ColumnFamilyDescriptorBuilder.newBuilder(HConstants.REPLICATION_BARRIER_FAMILY).setMaxVersions(Integer.MAX_VALUE).setInMemory(true).setScope(0).setBloomFilterType(BloomType.NONE).build();
    }

    public static TableDescriptorBuilder createMetaTableDescriptorBuilder(Configuration conf) throws IOException {
        return TableDescriptorBuilder.newBuilder(TableName.META_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(HConstants.CATALOG_FAMILY).setMaxVersions(conf.getInt("hbase.meta.versions", 3)).setInMemory(true).setBlocksize(conf.getInt("hbase.meta.blocksize", 8192)).setScope(0).setBloomFilterType(BloomType.NONE).build()).setColumnFamily(FSTableDescriptors.getTableFamilyDescForMeta(conf)).setColumnFamily(FSTableDescriptors.getReplBarrierFamilyDescForMeta()).setCoprocessor(CoprocessorDescriptorBuilder.newBuilder(MultiRowMutationEndpoint.class.getName()).setPriority(0x1FFFFFFF).build());
    }

    protected boolean isUsecache() {
        return this.usecache;
    }

    @Override
    @Nullable
    public TableDescriptor get(TableName tableName) {
        ++this.invocations;
        if (this.usecache) {
            TableDescriptor cachedtdm = this.cache.get(tableName);
            if (cachedtdm != null) {
                ++this.cachehits;
                return cachedtdm;
            }
            if (this.fsvisited) {
                return null;
            }
        }
        TableDescriptor tdmt = null;
        try {
            tdmt = FSTableDescriptors.getTableDescriptorFromFs(this.fs, this.rootdir, tableName);
        }
        catch (TableInfoMissingException tableInfoMissingException) {
        }
        catch (IOException | NullPointerException ioe) {
            LOG.debug("Exception during readTableDecriptor. Current table name = " + tableName, (Throwable)ioe);
        }
        if (this.usecache && tdmt != null) {
            this.cache.put(tableName, tdmt);
        }
        return tdmt;
    }

    @Override
    public Map<String, TableDescriptor> getAll() throws IOException {
        TreeMap<String, TableDescriptor> tds = new TreeMap<String, TableDescriptor>();
        if (this.fsvisited) {
            for (Map.Entry<TableName, TableDescriptor> entry : this.cache.entrySet()) {
                tds.put(entry.getKey().getNameWithNamespaceInclAsString(), entry.getValue());
            }
        } else {
            LOG.trace("Fetching table descriptors from the filesystem.");
            boolean allvisited = this.usecache;
            for (Path d : FSUtils.getTableDirs(this.fs, this.rootdir)) {
                TableDescriptor htd = this.get(CommonFSUtils.getTableName(d));
                if (htd == null) {
                    allvisited = false;
                    continue;
                }
                tds.put(htd.getTableName().getNameWithNamespaceInclAsString(), htd);
            }
            this.fsvisited = allvisited;
        }
        return tds;
    }

    @Override
    public Map<String, TableDescriptor> getByNamespace(String name) throws IOException {
        TreeMap<String, TableDescriptor> htds = new TreeMap<String, TableDescriptor>();
        List<Path> tableDirs = FSUtils.getLocalTableDirs(this.fs, CommonFSUtils.getNamespaceDir(this.rootdir, name));
        for (Path d : tableDirs) {
            TableDescriptor htd = this.get(CommonFSUtils.getTableName(d));
            if (htd == null) continue;
            htds.put(CommonFSUtils.getTableName(d).getNameAsString(), htd);
        }
        return htds;
    }

    @Override
    public void update(TableDescriptor td, boolean cacheOnly) throws IOException {
        if (this.fsreadonly) {
            throw new UnsupportedOperationException("Cannot add a table descriptor - in read only mode");
        }
        if (!cacheOnly) {
            this.updateTableDescriptor(td);
        }
        if (this.usecache) {
            this.cache.put(td.getTableName(), td);
        }
    }

    Path updateTableDescriptor(TableDescriptor td) throws IOException {
        TableName tableName = td.getTableName();
        Path tableDir = this.getTableDir(tableName);
        Path p = FSTableDescriptors.writeTableDescriptor(this.fs, td, tableDir, this.getTableInfoPath(tableDir));
        if (p == null) {
            throw new IOException("Failed update");
        }
        LOG.info("Updated tableinfo=" + p);
        return p;
    }

    @Override
    public TableDescriptor remove(TableName tablename) throws IOException {
        if (this.fsreadonly) {
            throw new NotImplementedException("Cannot remove a table descriptor - in read only mode");
        }
        Path tabledir = this.getTableDir(tablename);
        if (this.fs.exists(tabledir) && !this.fs.delete(tabledir, true)) {
            throw new IOException("Failed delete of " + tabledir.toString());
        }
        TableDescriptor descriptor = this.cache.remove(tablename);
        return descriptor;
    }

    private FileStatus getTableInfoPath(Path tableDir) throws IOException {
        return FSTableDescriptors.getTableInfoPath(this.fs, tableDir, !this.fsreadonly);
    }

    public static FileStatus getTableInfoPath(FileSystem fs, Path tableDir) throws IOException {
        return FSTableDescriptors.getTableInfoPath(fs, tableDir, false);
    }

    private static FileStatus getTableInfoPath(FileSystem fs, Path tableDir, boolean removeOldFiles) throws IOException {
        Path tableInfoDir = new Path(tableDir, TABLEINFO_DIR);
        return FSTableDescriptors.getCurrentTableInfoStatus(fs, tableInfoDir, removeOldFiles);
    }

    private static FileStatus getCurrentTableInfoStatus(FileSystem fs, Path dir, boolean removeOldFiles) throws IOException {
        FileStatus[] status = CommonFSUtils.listStatus(fs, dir, TABLEINFO_PATHFILTER);
        if (status == null || status.length < 1) {
            return null;
        }
        FileStatus mostCurrent = null;
        for (FileStatus file : status) {
            if (mostCurrent != null && TABLEINFO_FILESTATUS_COMPARATOR.compare(file, mostCurrent) >= 0) continue;
            mostCurrent = file;
        }
        if (removeOldFiles && status.length > 1) {
            for (FileStatus file : status) {
                Path path = file.getPath();
                if (file.equals((Object)mostCurrent)) continue;
                if (!fs.delete(file.getPath(), false)) {
                    LOG.warn("Failed cleanup of " + path);
                    continue;
                }
                LOG.debug("Cleaned up old tableinfo file " + path);
            }
        }
        return mostCurrent;
    }

    Path getTableDir(TableName tableName) {
        return CommonFSUtils.getTableDir(this.rootdir, tableName);
    }

    private static String formatTableInfoSequenceId(int number) {
        byte[] b = new byte[10];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return Bytes.toString(b);
    }

    static int getTableInfoSequenceId(Path p) {
        if (p == null) {
            return 0;
        }
        Matcher m = TABLEINFO_FILE_REGEX.matcher(p.getName());
        if (!m.matches()) {
            throw new IllegalArgumentException(p.toString());
        }
        String suffix = m.group(2);
        if (suffix == null || suffix.length() <= 0) {
            return 0;
        }
        return Integer.parseInt(m.group(2));
    }

    static String getTableInfoFileName(int sequenceid) {
        return ".tableinfo." + FSTableDescriptors.formatTableInfoSequenceId(sequenceid);
    }

    public static TableDescriptor getTableDescriptorFromFs(FileSystem fs, Path hbaseRootDir, TableName tableName) throws IOException {
        Path tableDir = CommonFSUtils.getTableDir(hbaseRootDir, tableName);
        return FSTableDescriptors.getTableDescriptorFromFs(fs, tableDir);
    }

    public static TableDescriptor getTableDescriptorFromFs(FileSystem fs, Path tableDir) throws IOException {
        FileStatus status = FSTableDescriptors.getTableInfoPath(fs, tableDir, false);
        if (status == null) {
            throw new TableInfoMissingException("No table descriptor file under " + tableDir);
        }
        return FSTableDescriptors.readTableDescriptor(fs, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableDescriptor readTableDescriptor(FileSystem fs, FileStatus status) throws IOException {
        int len = Ints.checkedCast(status.getLen());
        byte[] content = new byte[len];
        try (FSDataInputStream fsDataInputStream = fs.open(status.getPath());){
            fsDataInputStream.readFully(content);
        }
        TableDescriptor htd = null;
        try {
            htd = TableDescriptorBuilder.parseFrom(content);
        }
        catch (DeserializationException e) {
            throw new IOException("content=" + Bytes.toShort(content), e);
        }
        return htd;
    }

    private static void deleteTableDescriptorFiles(FileSystem fs, Path dir, int maxSequenceId) throws IOException {
        FileStatus[] status;
        for (FileStatus file : status = CommonFSUtils.listStatus(fs, dir, TABLEINFO_PATHFILTER)) {
            Path path = file.getPath();
            int sequenceId = FSTableDescriptors.getTableInfoSequenceId(path);
            if (sequenceId > maxSequenceId) continue;
            boolean success = CommonFSUtils.delete(fs, path, false);
            if (success) {
                LOG.debug("Deleted " + path);
                continue;
            }
            LOG.error("Failed to delete table descriptor at " + path);
        }
    }

    private static Path writeTableDescriptor(FileSystem fs, TableDescriptor htd, Path tableDir, FileStatus currentDescriptorFile) throws IOException {
        int currentSequenceId;
        Path tmpTableDir = new Path(tableDir, TMP_DIR);
        Path tableInfoDir = new Path(tableDir, TABLEINFO_DIR);
        int newSequenceId = currentSequenceId = currentDescriptorFile == null ? 0 : FSTableDescriptors.getTableInfoSequenceId(currentDescriptorFile.getPath());
        int retries = 10;
        int retrymax = currentSequenceId + retries;
        Path tableInfoDirPath = null;
        do {
            String filename;
            Path tempPath;
            if (fs.exists(tempPath = new Path(tmpTableDir, filename = FSTableDescriptors.getTableInfoFileName(++newSequenceId)))) {
                LOG.debug(tempPath + " exists; retrying up to " + retries + " times");
                continue;
            }
            tableInfoDirPath = new Path(tableInfoDir, filename);
            try {
                FSTableDescriptors.writeTD(fs, tempPath, htd);
                fs.mkdirs(tableInfoDirPath.getParent());
                if (!fs.rename(tempPath, tableInfoDirPath)) {
                    throw new IOException("Failed rename of " + tempPath + " to " + tableInfoDirPath);
                }
                LOG.debug("Wrote into " + tableInfoDirPath);
                break;
            }
            catch (IOException ioe) {
                LOG.debug("Failed write and/or rename; retrying", (Throwable)ioe);
                if (!CommonFSUtils.deleteDirectory(fs, tempPath)) {
                    LOG.warn("Failed cleanup of " + tempPath);
                }
                tableInfoDirPath = null;
            }
        } while (newSequenceId < retrymax);
        if (tableInfoDirPath != null) {
            FSTableDescriptors.deleteTableDescriptorFiles(fs, tableInfoDir, newSequenceId - 1);
        }
        return tableInfoDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTD(FileSystem fs, Path p, TableDescriptor htd) throws IOException {
        try (FSDataOutputStream out = fs.create(p, false);){
            out.write(TableDescriptorBuilder.toByteArray(htd));
        }
    }

    public boolean createTableDescriptor(TableDescriptor htd) throws IOException {
        return this.createTableDescriptor(htd, false);
    }

    public boolean createTableDescriptor(TableDescriptor htd, boolean forceCreation) throws IOException {
        Path tableDir = this.getTableDir(htd.getTableName());
        return this.createTableDescriptorForTableDirectory(tableDir, htd, forceCreation);
    }

    public boolean createTableDescriptorForTableDirectory(Path tableDir, TableDescriptor htd, boolean forceCreation) throws IOException {
        if (this.fsreadonly) {
            throw new NotImplementedException("Cannot create a table descriptor - in read only mode");
        }
        return FSTableDescriptors.createTableDescriptorForTableDirectory(this.fs, tableDir, htd, forceCreation);
    }

    public static boolean createTableDescriptorForTableDirectory(FileSystem fs, Path tableDir, TableDescriptor htd, boolean forceCreation) throws IOException {
        FileStatus status = FSTableDescriptors.getTableInfoPath(fs, tableDir);
        if (status != null) {
            LOG.debug("Current path=" + status.getPath());
            if (!forceCreation && fs.exists(status.getPath()) && status.getLen() > 0L && FSTableDescriptors.readTableDescriptor(fs, status).equals(htd)) {
                LOG.trace("TableInfo already exists.. Skipping creation");
                return false;
            }
        }
        return FSTableDescriptors.writeTableDescriptor(fs, htd, tableDir, status) != null;
    }
}

