/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import io.hops.hudi.org.apache.hadoop.hbase.util.BloomContext;
import io.hops.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowBloomContext
extends BloomContext {
    public RowBloomContext(BloomFilterWriter bloomFilterWriter, CellComparator comparator) {
        super(bloomFilterWriter, comparator);
    }

    @Override
    public void addLastBloomKey(HFile.Writer writer) throws IOException {
        if (this.getLastCell() != null) {
            byte[] key = CellUtil.copyRow(this.getLastCell());
            writer.appendFileInfo(HStoreFile.LAST_BLOOM_KEY, key);
        }
    }

    @Override
    protected boolean isNewKey(Cell cell) {
        if (this.getLastCell() != null) {
            return !CellUtil.matchingRows(cell, this.getLastCell());
        }
        return true;
    }
}

