/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.core;

import io.hops.hudi.org.apache.htrace.core.Span;
import io.hops.hudi.org.apache.htrace.core.SpanId;
import io.hops.hudi.org.apache.htrace.core.TimelineAnnotation;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ObjectReader;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ObjectWriter;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=MilliSpanDeserializer.class)
public class MilliSpan
implements Span {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static ObjectReader JSON_READER = OBJECT_MAPPER.reader(MilliSpan.class);
    private static ObjectWriter JSON_WRITER = OBJECT_MAPPER.writer();
    private static final SpanId[] EMPTY_PARENT_ARRAY = new SpanId[0];
    private static final String EMPTY_STRING = "";
    private long begin;
    private long end;
    private final String description;
    private SpanId[] parents;
    private final SpanId spanId;
    private Map<String, String> traceInfo = null;
    private String tracerId;
    private List<TimelineAnnotation> timeline = null;

    @Override
    public Span child(String childDescription) {
        return new Builder().begin(System.currentTimeMillis()).end(0L).description(childDescription).parents(new SpanId[]{this.spanId}).spanId(this.spanId.newChildId()).tracerId(this.tracerId).build();
    }

    public MilliSpan() {
        this.begin = 0L;
        this.end = 0L;
        this.description = EMPTY_STRING;
        this.parents = EMPTY_PARENT_ARRAY;
        this.spanId = SpanId.INVALID;
        this.traceInfo = null;
        this.tracerId = EMPTY_STRING;
        this.timeline = null;
    }

    private MilliSpan(Builder builder) {
        this.begin = builder.begin;
        this.end = builder.end;
        this.description = builder.description;
        this.parents = builder.parents;
        this.spanId = builder.spanId;
        this.traceInfo = builder.traceInfo;
        this.tracerId = builder.tracerId;
        this.timeline = builder.timeline;
    }

    @Override
    public synchronized void stop() {
        if (this.end == 0L) {
            if (this.begin == 0L) {
                throw new IllegalStateException("Span for " + this.description + " has not been started");
            }
            this.end = System.currentTimeMillis();
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.begin != 0L && this.end == 0L;
    }

    @Override
    public synchronized long getAccumulatedMillis() {
        if (this.begin == 0L) {
            return 0L;
        }
        if (this.end > 0L) {
            return this.end - this.begin;
        }
        return this.currentTimeMillis() - this.begin;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Override
    public SpanId[] getParents() {
        return this.parents;
    }

    @Override
    public void setParents(SpanId[] parents) {
        this.parents = parents;
    }

    @Override
    public long getStartTimeMillis() {
        return this.begin;
    }

    @Override
    public long getStopTimeMillis() {
        return this.end;
    }

    @Override
    public void addKVAnnotation(String key, String value) {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<String, String>();
        }
        this.traceInfo.put(key, value);
    }

    @Override
    public void addTimelineAnnotation(String msg) {
        if (this.timeline == null) {
            this.timeline = new ArrayList<TimelineAnnotation>();
        }
        this.timeline.add(new TimelineAnnotation(System.currentTimeMillis(), msg));
    }

    @Override
    public Map<String, String> getKVAnnotations() {
        if (this.traceInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.traceInfo);
    }

    @Override
    public List<TimelineAnnotation> getTimelineAnnotations() {
        if (this.timeline == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.timeline);
    }

    @Override
    public String getTracerId() {
        return this.tracerId;
    }

    @Override
    public void setTracerId(String tracerId) {
        this.tracerId = tracerId;
    }

    @Override
    public String toJson() {
        StringWriter writer = new StringWriter();
        try {
            JSON_WRITER.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static MilliSpan fromJson(String json) throws IOException {
        return (MilliSpan)JSON_READER.readValue(json);
    }

    static /* synthetic */ SpanId[] access$000() {
        return EMPTY_PARENT_ARRAY;
    }

    public static class MilliSpanDeserializer
    extends JsonDeserializer<MilliSpan> {
        @Override
        public MilliSpan deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode timelineNode;
            JsonNode rNode;
            JsonNode sNode;
            JsonNode dNode;
            JsonNode eNode;
            JsonNode root = (JsonNode)jp.getCodec().readTree(jp);
            Builder builder = new Builder();
            JsonNode bNode = root.get("b");
            if (bNode != null) {
                builder.begin(bNode.asLong());
            }
            if ((eNode = root.get("e")) != null) {
                builder.end(eNode.asLong());
            }
            if ((dNode = root.get("d")) != null) {
                builder.description(dNode.asText());
            }
            if ((sNode = root.get("a")) != null) {
                builder.spanId(SpanId.fromString(sNode.asText()));
            }
            if ((rNode = root.get("r")) != null) {
                builder.tracerId(rNode.asText());
            }
            JsonNode parentsNode = root.get("p");
            LinkedList<SpanId> parents = new LinkedList<SpanId>();
            if (parentsNode != null) {
                Iterator<JsonNode> iter = parentsNode.elements();
                while (iter.hasNext()) {
                    JsonNode parentIdNode = iter.next();
                    parents.add(SpanId.fromString(parentIdNode.asText()));
                }
            }
            builder.parents(parents);
            JsonNode traceInfoNode = root.get("n");
            if (traceInfoNode != null) {
                HashMap<String, String> traceInfo = new HashMap<String, String>();
                Iterator<String> iter = traceInfoNode.fieldNames();
                while (iter.hasNext()) {
                    String field2 = iter.next();
                    traceInfo.put(field2, traceInfoNode.get(field2).asText());
                }
                builder.traceInfo(traceInfo);
            }
            if ((timelineNode = root.get("t")) != null) {
                LinkedList<TimelineAnnotation> timeline = new LinkedList<TimelineAnnotation>();
                Iterator<JsonNode> iter = timelineNode.elements();
                while (iter.hasNext()) {
                    JsonNode ann = iter.next();
                    timeline.add(new TimelineAnnotation(ann.get("t").asLong(), ann.get("m").asText()));
                }
                builder.timeline(timeline);
            }
            return builder.build();
        }
    }

    public static class Builder {
        private long begin;
        private long end;
        private String description = "";
        private SpanId[] parents = MilliSpan.access$000();
        private SpanId spanId = SpanId.INVALID;
        private Map<String, String> traceInfo = null;
        private String tracerId = "";
        private List<TimelineAnnotation> timeline = null;

        public Builder begin(long begin) {
            this.begin = begin;
            return this;
        }

        public Builder end(long end) {
            this.end = end;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parents(SpanId[] parents) {
            this.parents = parents;
            return this;
        }

        public Builder parents(List<SpanId> parentList) {
            SpanId[] parents = new SpanId[parentList.size()];
            for (int i = 0; i < parentList.size(); ++i) {
                parents[i] = parentList.get(i);
            }
            this.parents = parents;
            return this;
        }

        public Builder spanId(SpanId spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder traceInfo(Map<String, String> traceInfo) {
            this.traceInfo = traceInfo.isEmpty() ? null : traceInfo;
            return this;
        }

        public Builder tracerId(String tracerId) {
            this.tracerId = tracerId;
            return this;
        }

        public Builder timeline(List<TimelineAnnotation> timeline) {
            this.timeline = timeline.isEmpty() ? null : timeline;
            return this;
        }

        public MilliSpan build() {
            return new MilliSpan(this);
        }
    }
}

