/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.cookie;

import io.hops.hudi.org.apache.http.FormattedHeader;
import io.hops.hudi.org.apache.http.Header;
import io.hops.hudi.org.apache.http.HeaderElement;
import io.hops.hudi.org.apache.http.NameValuePair;
import io.hops.hudi.org.apache.http.annotation.ThreadSafe;
import io.hops.hudi.org.apache.http.cookie.Cookie;
import io.hops.hudi.org.apache.http.cookie.CookieAttributeHandler;
import io.hops.hudi.org.apache.http.cookie.CookieOrigin;
import io.hops.hudi.org.apache.http.cookie.MalformedCookieException;
import io.hops.hudi.org.apache.http.impl.cookie.BasicClientCookie;
import io.hops.hudi.org.apache.http.impl.cookie.BasicCommentHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BasicDomainHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BasicExpiresHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BasicPathHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BasicSecureHandler;
import io.hops.hudi.org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import io.hops.hudi.org.apache.http.impl.cookie.BrowserCompatVersionAttributeHandler;
import io.hops.hudi.org.apache.http.impl.cookie.CookieSpecBase;
import io.hops.hudi.org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import io.hops.hudi.org.apache.http.message.BasicHeaderElement;
import io.hops.hudi.org.apache.http.message.BasicHeaderValueFormatter;
import io.hops.hudi.org.apache.http.message.BufferedHeader;
import io.hops.hudi.org.apache.http.message.ParserCursor;
import io.hops.hudi.org.apache.http.util.Args;
import io.hops.hudi.org.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@ThreadSafe
public class BrowserCompatSpec
extends CookieSpecBase {
    private static final String[] DEFAULT_DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"};

    public BrowserCompatSpec(String[] datepatterns, BrowserCompatSpecFactory.SecurityLevel securityLevel) {
        super(new BrowserCompatVersionAttributeHandler(), new BasicDomainHandler(), securityLevel == BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_IE_MEDIUM ? new BasicPathHandler(){

            @Override
            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }
        } : new BasicPathHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(datepatterns != null ? (String[])datepatterns.clone() : DEFAULT_DATE_PATTERNS));
    }

    public BrowserCompatSpec(String[] datepatterns) {
        this(datepatterns, BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    public BrowserCompatSpec() {
        this(null, BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        String headername = header.getName();
        if (!headername.equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new ParserCursor(0, buffer.length());
            }
            HeaderElement elem = parser.parseHeader(buffer, cursor);
            String name = elem.getName();
            String value = elem.getValue();
            if (name == null || name.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(BrowserCompatSpec.getDefaultPath(origin));
            cookie.setDomain(BrowserCompatSpec.getDefaultDomain(origin));
            NameValuePair[] attribs = elem.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            if (netscape) {
                cookie.setVersion(0);
            }
            return Collections.singletonList(cookie);
        }
        return this.parse(helems, origin);
    }

    private static boolean isQuoteEnclosed(String s) {
        return s != null && s.startsWith("\"") && s.endsWith("\"");
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notEmpty(cookies, "List of cookies");
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (cookie.getVersion() > 0 && !BrowserCompatSpec.isQuoteEnclosed(cookieValue)) {
                BasicHeaderValueFormatter.INSTANCE.formatHeaderElement(buffer, new BasicHeaderElement(cookieName, cookieValue), false);
                continue;
            }
            buffer.append(cookieName);
            buffer.append("=");
            if (cookieValue == null) continue;
            buffer.append(cookieValue);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "compatibility";
    }
}

